package com.ximai.mes.pro.service;

import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProProductQrcodeRecord;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordCreate;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordUpdate;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordDto;

/**
 * 产品序列号打印记录Service接口
 * 
 * @author generator
 * @date 2024-08-31
 */
public interface IProProductQrcodeRecordService 
{
    /**
     * 查询产品序列号打印记录
     *
     * @param recordId 产品序列号打印记录主键
     * @return 产品序列号打印记录
     */
    public ProProductQrcodeRecordDto selectProProductQrcodeRecordDtoByRecordId(Long recordId);

    /**
     * 查询产品序列号打印记录
     *
     * @param recordId 产品序列号打印记录主键
     * @return 产品序列号打印记录
     */
    public ProProductQrcodeRecord selectProProductQrcodeRecordByRecordId(Long recordId);

    /**
     * 查询产品序列号打印记录列表
     *
     * @param proProductQrcodeRecord 产品序列号打印记录
     * @return 产品序列号打印记录集合
     */
    public List<ProProductQrcodeRecordDto> selectProProductQrcodeRecordList(ProProductQrcodeRecord proProductQrcodeRecord);

    /**
     * 查询产品序列号打印记录列表
     *
     * @param proProductQrcodeRecordQuery 产品序列号打印记录
     * @return 产品序列号打印记录集合
     */
    public List<ProProductQrcodeRecord> selectProProductQrcodeRecordList(QueryWrapper<ProProductQrcodeRecord> proProductQrcodeRecordQuery);

    /**
     * 查询产品序列号打印记录列表
     *
     * @param proProductQrcodeRecordQuery 产品序列号打印记录
     * @return 产品序列号打印记录集合
     */
    public List<ProProductQrcodeRecordDto> selectProProductQrcodeRecordDtoList(QueryWrapper<ProProductQrcodeRecord> proProductQrcodeRecordQuery);

    /**
     * 新增产品序列号打印记录
     * 
     * @param proProductQrcodeRecord 产品序列号打印记录
     * @return 结果
     */
    public int insertProProductQrcodeRecord(ProProductQrcodeRecordCreate proProductQrcodeRecord);

    /**
     * 修改产品序列号打印记录
     * 
     * @param proProductQrcodeRecord 产品序列号打印记录
     * @return 结果
     */
    public int updateProProductQrcodeRecord(ProProductQrcodeRecordUpdate proProductQrcodeRecord);

    /**
     * 批量删除产品序列号打印记录
     * 
     * @param recordIds 需要删除的产品序列号打印记录主键集合
     * @return 结果
     */
    public int deleteProProductQrcodeRecordByRecordIds(Long[] recordIds);

    /**
     * 删除产品序列号打印记录信息
     * 
     * @param recordId 产品序列号打印记录主键
     * @return 结果
     */
    public int deleteProProductQrcodeRecordByRecordId(Long recordId);
}
