package com.ximai.mes.pro.schedule.impl.busi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.pro.domain.ProProductQrcodeRule;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordCreate;
import com.ximai.mes.pro.schedule.impl.AlgorithmResultProcessImpl;
import com.ximai.mes.pro.service.IProMaterialRequestService;
import com.ximai.mes.pro.service.IProProductQrcodeRecordService;
import com.ximai.mes.pro.service.IProProductQrcodeRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 产品序列号生成
 */
@Component
public class ProductQrcodeBuild implements ScheduleBusiProcess{

    @Autowired
    private IProProductQrcodeRecordService productQrcodeRecordService;
    @Autowired
    private IProProductQrcodeRuleService productQrcodeRuleService;
    @Override
    public void execute(List<JobResult> jobResults) {
        jobResults.forEach(job->{
            job.getWorkorderList().forEach(workorder->{
                ProProductQrcodeRule rule = productQrcodeRuleService.selectProProductQrcodeRuleNewest(workorder.getProductId(), workorder.getClientCode());
                if(rule ==null){
                    return;
                }
                List<String> qrcodes = productQrcodeRuleService.buildQrcode(rule, job.getQuantity().intValue());
                for(String qrcode : qrcodes){
                    ProProductQrcodeRecordCreate create = new ProProductQrcodeRecordCreate();
                    create.setQrcode(qrcode);
                    create.initByWorkorder(workorder);
                    create.setItemDesc(rule.getItemDesc());
                    productQrcodeRecordService.insertProProductQrcodeRecord(create);
                }
            });
        });
    }

}
