package com.ximai.mes.pro.mapper.productionSolution;

import com.ximai.mes.pro.domain.productionSolution.ProProductionSolution;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionSpecificationSheet;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 生产版本Mapper接口
 *
 * @author zht
 * @date 2024-01-23
 */
public interface ProProductionSolutionMapper {
    /**
     * 查询生产版本
     *
     * @param productionSolutionId 生产版本主键
     * @return 生产版本
     */
    ProProductionSolution selectProProductionSolutionByProductionSolutionId(Long productionSolutionId);

    /**
     * 查询生产版本列表
     *
     * @param proProductionSolution 生产版本
     * @return 生产版本集合
     */
    List<ProProductionSolution> selectProProductionSolutionList(ProProductionSolution proProductionSolution);

    /**
     * 新增生产版本
     *
     * @param proProductionSolution 生产版本
     * @return 结果
     */
    int insertProProductionSolution(ProProductionSolution proProductionSolution);

    /**
     * 修改生产版本
     *
     * @param proProductionSolution 生产版本
     * @return 结果
     */
    int updateProProductionSolution(ProProductionSolution proProductionSolution);

    /**
     * 删除生产版本
     *
     * @param productionSolutionId 生产版本主键
     * @return 结果
     */
    int deleteProProductionSolutionByProductionSolutionId(Long productionSolutionId);

    /**
     * 批量删除生产版本
     *
     * @param productionSolutionIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProProductionSolutionByProductionSolutionIds(Long[] productionSolutionIds);

    ProProductionSolution selectProProductionSolutionBySapPrototypeMakeCode(@Param("sapPrototypeMakeCode") String sapPrototypeMakeCode);


    /**
     * 通过版本号查询生产方案
     *
     * @param groupKey
     * @param groupCounter
     * @return
     */
    ProProductionSolution selectByGroupKeyAndGroupCounterAndSapItemCode(@Param("groupKey") String groupKey, @Param("groupCounter") String groupCounter, @Param("sapItemCode") String sapItemCode);

    @Select(" select s.module,s.printing_paperlenth from pro_production_solution pps\n" +
            "\tleft join pro_production_solution_specification_sheet s\n" +
            " on pps.production_solution_id=s.production_solution_id  \n" +
            " where CONCAT(group_key, group_counter) like concat('%', #{groupCounter}, '%') ")
    ProProductionSolutionSpecificationSheet selectModule(@Param("groupCounter") String groupCounter);
}
