package com.ximai.mes.pro.domain.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderBom;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderSoDirective;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderSoSizeItem;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolution;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionSpecificationSheet;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.domain.vo.proWorkOrder.WorkOrderSoSizeItemStandard;
import com.ximai.mes.pro.domain.vo.proWorkOrder.WorkorderPackage;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProWorkorderVo extends BaseEntity {
    private static final long serialVersionUID = -7889020903940196496L;

    private Long workorderId;

    private Long[] workorderIds;


    private Long parentId;
    /**
     * 工艺路线ID
     */
    private Long routeId;

    private String routeName;

    private String routeCode;

    private String rowNum;


    /**
     * 工单编码
     */
    private String workorderCode;

    private String parentCode;

    private String sapItemCode;

    /**
     * 工单名称
     */
    private String workorderName;

    /**
     * 工单类型
     */
    private String workorderType;

    /**
     * 来源类型
     */
    private String orderSource;

    /**
     * 来源单据
     */
    private String sourceCode;

    /**
     * 产品ID
     */
    private Long productId;

    /**
     * 产品编号
     */
    private String productCode;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 规格型号
     */
    private String productSpc;

    /**
     * 单位
     */
    private String unitOfMeasure;

    private String unitOfConvert;

    /**
     * 批次号
     */
    private String batchCode;

    /**
     * 生产数量
     */
    private BigDecimal quantity;

    /**
     * 已生产数量
     */
    private BigDecimal quantityProduced;


    /**
     * 订单开始日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "订单开始日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 调整数量
     */
    private BigDecimal quantityChanged;
    private BigDecimal quantityWait;

    /**
     * 已排产数量
     */
    private BigDecimal quantityScheduled;

    /**
     * 客户ID
     */
    private Long clientId;

    /**
     * 客户编码
     */
    private String clientCode;

    /**
     * 客户名称
     */
    private String clientName;

    /**
     * 供应商ID
     */
    private Long vendorId;

    /**
     * 供应商编号
     */
    private String vendorCode;

    /**
     * 供应商名称
     */
    private String vendorName;


    private String arrangeCode;


    /**
     * 需求日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date requestDate;

    /**
     * 完成时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date finishDate;

    /**
     * 单据状态
     */
    private String status;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;

    private List<ProTask> tasks;

    /**
     * Bom列表
     */
    private List<ProWorkOrderBom> bomList;

    /**
     * 生产版本
     */
    private ProProductionSolution proProductionSolution;


    /**
     * 规格书
     */
    private ProProductionSolutionSpecificationSheet proProductionSolutionSpecificationSheet;
    /**
     * 物料
     */
    private MdItem mdItem;
    /**
     * 工序列表
     */
    private List<ProWorkOrderProcessVo> processList;

    /**
     * 指令列表
     */
    @ApiModelProperty("指令列表")
    private List<ProWorkOrderSoDirective> saleDirectiveList;

    /**
     * size列表
     */
    @ApiModelProperty("SIZE列表")
    private List<ProWorkOrderSoSizeItem> sizeList;

    @ApiModelProperty("基准size列表")
    private List<WorkOrderSoSizeItemStandard> sizeList2;

    @ApiModelProperty("包装标签列表")
    private List<WorkorderPackage> packageList;

    @ApiModelProperty("包装数量")
    private BigDecimal packNum;

    @ApiModelProperty("按指令包装")
    private String packByDirective;

    private String packType;

    @ApiModelProperty("按size包装")
    private String packBySize;

    @ApiModelProperty("包装单位")
    private String packUnitOfMeasure;

    @ApiModelProperty("LOSS数是否单独包装，Y：是，N：否")
    private String lossIndividuallyWrap;

    @ApiModelProperty("装箱数量")
    private Integer encasementNum;

    @ApiModelProperty("使用包装数量")
    private Integer usagePackNum;

    @ApiModelProperty("使用装箱数量")
    private Integer usageEncasementNum;

    @ApiModelProperty("合并包装")
    private Integer mergePack;

    @TableField(exist = false)
    private String itemTypeName;

    /**
     * 是否急单
     */
    @Excel(name = "是否急单")
    private String  rushOrder;

    @ApiModelProperty("生产版本ID")
    private Long productionSolutionId;

    @ApiModelProperty("生产版本编码")
    private String productionSolutionCode;

    @ApiModelProperty("生产版本名称")
    private String productionSolutionName;

}
