package com.ximai.mes.pro.domain.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionBomItem;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

/**
 * 生产版本BOM头对象 pro_production_solution_bom_head
 *
 * @author zht
 * @date 2024-03-05
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProProductionSolutionBomHeadVo {

    /**
     * ID
     */
    @TableId(type = IdType.AUTO)
    private Long bomHeadId;

    /**
     * 生产版本ID
     */
    private Long productionSolutionId;

    /**
     * SAP物料编号
     */
    private String sapItemCode;

    /**
     * 物料名称
     */
    private String itemName;

    /**
     * 物料清单组号
     */
    private String materialsGroupBill;

    /**
     * 备选物料清单
     */
    private String alternativeBill;

    /**
     * 物料清单用途
     */
    private String usageCode;

    /**
     * 基本数量
     */
    private BigDecimal quantity;

    /**
     * 物料清单的基本计量单位
     */
    private String unitOfMeasure;

    /**
     * ECN 变更号
     */
    private String ecnCode;

    /**
     * 抬头文本描述
     */
    private String remark;

    /**
     * 从批量
     */
    private BigDecimal minLot;

    /**
     * 到批量
     */
    private BigDecimal maxLot;

    /**
     * 物料清单授权组
     */
    private String billOfMaterialsAuthorizationGroup;

    /**
     * 工厂
     */
    private String factoryCode;

    /**
     * BOM行列表
     */
    private List<ProProductionSolutionBomItem> bomItemList;

}
