package com.ximai.mes.pro.domain.prototypeRequest;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 打样申请BOM对象 pro_prototype_request_bom
 *
 * @author zht
 * @date 2024-01-18
 */
public class ProPrototypeRequestBom extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** ID */
    private Long bomItemId;

    /** 样品申请单ID */
    @Excel(name = "样品申请单ID")
    private Long prototypeRequestId;

    @Excel(name = "组件id")
    private Long itemId;

    @Excel(name = "组件名称")
    private String itemName;

    /** 组件数量 */
    @Excel(name = "组件数量")
    private BigDecimal quantity;

    /** 计量单位 */
    @Excel(name = "计量单位")
    private String unitOfMeasure;

    /** 报废百分比 */
    @Excel(name = "报废百分比")
    private BigDecimal scrapPercentage;

    /** 替代组 */
    @Excel(name = "替代组")
    private String alternativeGroup;

    /** 替代优先级 */
    @Excel(name = "替代优先级")
    private Long alternativePriorities;

    /** 替代策略 */
    @Excel(name = "替代策略")
    private String alternativeStrategy;

    /** 替代使用概率 */
    @Excel(name = "替代使用概率")
    private BigDecimal alternativeProbability;

    /** BOM行备注 */
    @Excel(name = "BOM行备注")
    private String bomItemRemark;

    /** 物料备注 */
    @Excel(name = "物料备注")
    private String itemRemark;

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public void setBomItemId(Long bomItemId)
    {
        this.bomItemId = bomItemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Long getBomItemId()
    {
        return bomItemId;
    }
    public void setPrototypeRequestId(Long prototypeRequestId)
    {
        this.prototypeRequestId = prototypeRequestId;
    }

    public Long getPrototypeRequestId()
    {
        return prototypeRequestId;
    }
    public void setQuantity(BigDecimal quantity)
    {
        this.quantity = quantity;
    }

    public BigDecimal getQuantity()
    {
        return quantity;
    }
    public void setUnitOfMeasure(String unitOfMeasure)
    {
        this.unitOfMeasure = unitOfMeasure;
    }

    public String getUnitOfMeasure()
    {
        return unitOfMeasure;
    }
    public void setScrapPercentage(BigDecimal scrapPercentage)
    {
        this.scrapPercentage = scrapPercentage;
    }

    public BigDecimal getScrapPercentage()
    {
        return scrapPercentage;
    }
    public void setAlternativeGroup(String alternativeGroup)
    {
        this.alternativeGroup = alternativeGroup;
    }

    public String getAlternativeGroup()
    {
        return alternativeGroup;
    }
    public void setAlternativePriorities(Long alternativePriorities)
    {
        this.alternativePriorities = alternativePriorities;
    }

    public Long getAlternativePriorities()
    {
        return alternativePriorities;
    }
    public void setAlternativeStrategy(String alternativeStrategy)
    {
        this.alternativeStrategy = alternativeStrategy;
    }

    public String getAlternativeStrategy()
    {
        return alternativeStrategy;
    }
    public void setAlternativeProbability(BigDecimal alternativeProbability)
    {
        this.alternativeProbability = alternativeProbability;
    }

    public BigDecimal getAlternativeProbability()
    {
        return alternativeProbability;
    }
    public void setBomItemRemark(String bomItemRemark)
    {
        this.bomItemRemark = bomItemRemark;
    }

    public String getBomItemRemark()
    {
        return bomItemRemark;
    }
    public void setItemRemark(String itemRemark)
    {
        this.itemRemark = itemRemark;
    }

    public String getItemRemark()
    {
        return itemRemark;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("bomItemId", getBomItemId())
            .append("prototypeRequestId", getPrototypeRequestId())
            .append("quantity", getQuantity())
            .append("unitOfMeasure", getUnitOfMeasure())
            .append("scrapPercentage", getScrapPercentage())
            .append("alternativeGroup", getAlternativeGroup())
            .append("alternativePriorities", getAlternativePriorities())
            .append("alternativeStrategy", getAlternativeStrategy())
            .append("alternativeProbability", getAlternativeProbability())
            .append("bomItemRemark", getBomItemRemark())
            .append("itemRemark", getItemRemark())
            .toString();
    }
}
