package com.ximai.mes.pro.controller.proWorkOrder;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcess;
import com.ximai.mes.pro.domain.vo.ProWorkOrderProcessVo;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderProcessService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * 生产工单工序Controller
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
@RestController
@RequestMapping("/pro/proWorkOrderProcess")
public class ProWorkOrderProcessController extends BaseController {
    @Autowired
    private IProWorkOrderProcessService proWorkOrderProcessService;

    /**
     * 查询生产工单工序列表
     */
    @ApiOperation("查询生产工单工序列表")
    @PreAuthorize("@ss.hasPermi('pro:proWorkOrderProcess:list')")
    @GetMapping("/list")
    public TableDataInfo<ProWorkOrderProcessVo> list(ProWorkOrderProcess proWorkOrderProcess) {
        startPage();
        List<ProWorkOrderProcessVo> list = proWorkOrderProcessService.selectProWorkOrderProcessList(proWorkOrderProcess);
        return getDataTable(list);
    }


    /**
     * 获取生产工单工序详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:proWorkOrderProcess:query')")
    @GetMapping(value = "/{workorderProcessId}")
    public AjaxResult getInfo(@PathVariable("workorderProcessId") Long workorderProcessId) {
        return AjaxResult.success(proWorkOrderProcessService.selectProWorkOrderProcessByWorkorderProcessId(workorderProcessId));
    }

    /**
     * 新增生产工单工序
     */
    @PreAuthorize("@ss.hasPermi('pro:proWorkOrderProcess:add')")
    @Log(title = "生产工单工序", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProWorkOrderProcess proWorkOrderProcess) {
        return toAjax(proWorkOrderProcessService.insertProWorkOrderProcess(proWorkOrderProcess));
    }

    /**
     * 修改生产工单工序
     */
    @PreAuthorize("@ss.hasPermi('pro:proWorkOrderProcess:edit')")
    @Log(title = "生产工单工序", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProWorkOrderProcess proWorkOrderProcess) {
        return toAjax(proWorkOrderProcessService.updateProWorkOrderProcess(proWorkOrderProcess));
    }

    /**
     * 删除生产工单工序
     */
    @PreAuthorize("@ss.hasPermi('pro:proWorkOrderProcess:remove')")
    @Log(title = "生产工单工序", businessType = BusinessType.DELETE)
    @DeleteMapping("/{workorderProcessIds}")
    public AjaxResult remove(@PathVariable Long[] workorderProcessIds) {
        return toAjax(proWorkOrderProcessService.deleteProWorkOrderProcessByWorkorderProcessIds(workorderProcessIds));
    }


}
