package com.ximai.mes.md.service.impl;

import com.ximai.common.core.domain.entity.SysDept;
import com.ximai.common.core.domain.entity.SysUser;
import com.ximai.common.utils.MessageUtils;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.mes.md.domain.MdWorkunitWorker;
import com.ximai.mes.md.mapper.MdWorkunitWorkerMapper;
import com.ximai.mes.md.service.IMdWorkunitWorkerService;
import com.ximai.system.mapper.SysDeptMapper;
import com.ximai.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 岗位资源Service业务层处理
 *
 * @author generator
 * @date 2024-07-17
 */
@Service
public class MdWorkunitWorkerServiceImpl implements IMdWorkunitWorkerService {
    @Autowired
    private MdWorkunitWorkerMapper mdWorkunitWorkerMapper;

    @Autowired
    private ISysUserService sysUserService;
    @Resource
    private SysDeptMapper sysDeptMapper;

    /**
     * 查询岗位资源
     *
     * @param id 岗位资源主键
     * @return 岗位资源
     */
    @Override
    public MdWorkunitWorker selectMdWorkunitWorkerById(Long id) {
        return mdWorkunitWorkerMapper.selectMdWorkunitWorkerById(id);
    }

    /**
     * 查询岗位资源列表
     *
     * @param mdWorkunitWorker 岗位资源
     * @return 岗位资源
     */
    @Override
    public List<MdWorkunitWorker> selectMdWorkunitWorkerList(MdWorkunitWorker mdWorkunitWorker) {
        return mdWorkunitWorkerMapper.selectMdWorkunitWorkerList(mdWorkunitWorker);
    }

    /**
     * 新增岗位资源
     *
     * @param mdWorkunitWorker 岗位资源
     * @return 结果
     */
    @Override
    public int insertMdWorkunitWorker(MdWorkunitWorker mdWorkunitWorker) {
        mdWorkunitWorker.createAction();
        return mdWorkunitWorkerMapper.insertMdWorkunitWorker(mdWorkunitWorker);
    }

    /**
     * 修改岗位资源
     *
     * @param mdWorkunitWorker 岗位资源
     * @return 结果
     */
    @Override
    public int updateMdWorkunitWorker(MdWorkunitWorker mdWorkunitWorker) {
        mdWorkunitWorker.updateAction();
        return mdWorkunitWorkerMapper.updateMdWorkunitWorker(mdWorkunitWorker);
    }

    /**
     * 批量删除岗位资源
     *
     * @param ids 需要删除的岗位资源主键
     * @return 结果
     */
    @Override
    public int deleteMdWorkunitWorkerByIds(Long[] ids) {
        return mdWorkunitWorkerMapper.deleteMdWorkunitWorkerByIds(ids);
    }

    /**
     * 删除岗位资源信息
     *
     * @param id 岗位资源主键
     * @return 结果
     */
    @Override
    public int deleteMdWorkunitWorkerById(Long id) {
        return mdWorkunitWorkerMapper.deleteMdWorkunitWorkerById(id);
    }

    @Override
    public int insertObj(MdWorkunitWorker mdWorkunitWorker) {
        SysUser sysUser = sysUserService.selectUserById(mdWorkunitWorker.getUserId());
        ExceptionUtil.checkTrueThrowException(sysUser == null, MessageUtils.message("md.workUnit.error.bind.not.user"));
        mdWorkunitWorker.setNickName(sysUser.getNickName());
        mdWorkunitWorker.setUserName(sysUser.getUserName());
        SysDept dept = sysDeptMapper.selectDeptById(mdWorkunitWorker.getUserId());
        if (dept != null) {
            mdWorkunitWorker.setPostId(dept.getDeptId());
            mdWorkunitWorker.setPostName(dept.getDeptName());
        }
        return this.insertMdWorkunitWorker(mdWorkunitWorker);
    }

    @Override
    public int updateObj(MdWorkunitWorker mdWorkunitWorker) {
        SysUser sysUser = sysUserService.selectUserById(mdWorkunitWorker.getUserId());
        ExceptionUtil.checkTrueThrowException(sysUser == null, MessageUtils.message("user.error.not.exist"));
        mdWorkunitWorker.setNickName(sysUser.getNickName());
        mdWorkunitWorker.setUserName(sysUser.getUserName());
        SysDept dept = sysDeptMapper.selectDeptById(mdWorkunitWorker.getUserId());
        if (dept != null) {
            mdWorkunitWorker.setPostId(dept.getDeptId());
            mdWorkunitWorker.setPostName(dept.getDeptName());
        }
        return this.updateMdWorkunitWorker(mdWorkunitWorker);
    }
}
