package com.ximai.mes.md.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdSaleOrderOrgMapper;
import com.ximai.mes.md.domain.MdSaleOrderOrg;
import com.ximai.mes.md.service.IMdSaleOrderOrgService;

/**
 * 销售订单组织Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@Service
public class MdSaleOrderOrgServiceImpl implements IMdSaleOrderOrgService
{
    @Autowired
    private MdSaleOrderOrgMapper mdSaleOrderOrgMapper;

    /**
     * 查询销售订单组织
     *
     * @param id 销售订单组织主键
     * @return 销售订单组织
     */
    @Override
    public MdSaleOrderOrg selectMdSaleOrderOrgById(Long id)
    {
        return mdSaleOrderOrgMapper.selectMdSaleOrderOrgById(id);
    }

    /**
     * 查询销售订单组织列表
     *
     * @param mdSaleOrderOrg 销售订单组织
     * @return 销售订单组织
     */
    @Override
    public List<MdSaleOrderOrg> selectMdSaleOrderOrgList(MdSaleOrderOrg mdSaleOrderOrg)
    {
        return mdSaleOrderOrgMapper.selectMdSaleOrderOrgList(mdSaleOrderOrg);
    }

    /**
     * 新增销售订单组织
     *
     * @param mdSaleOrderOrg 销售订单组织
     * @return 结果
     */
    @Override
    public int insertMdSaleOrderOrg(MdSaleOrderOrg mdSaleOrderOrg)
    {
        return mdSaleOrderOrgMapper.insertMdSaleOrderOrg(mdSaleOrderOrg);
    }

    /**
     * 修改销售订单组织
     *
     * @param mdSaleOrderOrg 销售订单组织
     * @return 结果
     */
    @Override
    public int updateMdSaleOrderOrg(MdSaleOrderOrg mdSaleOrderOrg)
    {
        return mdSaleOrderOrgMapper.updateMdSaleOrderOrg(mdSaleOrderOrg);
    }

    /**
     * 批量删除销售订单组织
     *
     * @param ids 需要删除的销售订单组织主键
     * @return 结果
     */
    @Override
    public int deleteMdSaleOrderOrgByIds(Long[] ids)
    {
        return mdSaleOrderOrgMapper.deleteMdSaleOrderOrgByIds(ids);
    }

    /**
     * 删除销售订单组织信息
     *
     * @param id 销售订单组织主键
     * @return 结果
     */
    @Override
    public int deleteMdSaleOrderOrgById(Long id)
    {
        return mdSaleOrderOrgMapper.deleteMdSaleOrderOrgById(id);
    }
}
