package com.ximai.mes.md.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 颜色主数据对象 md_color
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
public class MdColor extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 颜色主键id */
    private Long colorId;

    /** 颜色编码 */
    @Excel(name = "颜色编码")
    private String colorCode;

    /** 颜色名称 */
    @Excel(name = "颜色名称")
    private String colorName;

    public void setColorId(Long colorId)
    {
        this.colorId = colorId;
    }

    public Long getColorId()
    {
        return colorId;
    }
    public void setColorCode(String colorCode)
    {
        this.colorCode = colorCode;
    }

    public String getColorCode()
    {
        return colorCode;
    }
    public void setColorName(String colorName)
    {
        this.colorName = colorName;
    }

    public String getColorName()
    {
        return colorName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("colorId", getColorId())
            .append("colorCode", getColorCode())
            .append("colorName", getColorName())
            .toString();
    }
}
