package com.ximai.mes.report.response;

import com.ximai.common.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class FeedbackResponseExportByWorkOrder {
    @ApiModelProperty(     "工单编码")
    @Excel(name = "生产工单")
    private String workorderCode;

    @ApiModelProperty(     "工单名称")
    @Excel(name = "工单名称")
    private String workorderName;


    /**
     * 本次报工数量
     */
    @ApiModelProperty(     "报工数量")
    @Excel(name = "报工数量")
    private BigDecimal quantityFeedback;

    /**
     * 合格品数量
     */
    @ApiModelProperty(     "合格数量")
    @Excel(name = "合格数量")
    private BigDecimal quantityQualify;

    /**
     * 不良品数量
     */
    @ApiModelProperty(     "不合格数量")
    @Excel(name = "不合格数量")
    private BigDecimal quantityUnqualify;




    @ApiModelProperty("良率")
    @Excel(name = "良率")
    private String qualificationRate;
}
