package com.ximai.mes.md.dto;

import java.math.BigDecimal;
import io.swagger.annotations.ApiModelProperty;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 物料仓库对象 md_item_warehouse
 *
 * @author generator
 * @date 2024-10-20
 */
@Data
public class MdItemWarehouseQuery {
    private static final long serialVersionUID = 1L;

    /** 物料仓库关联ID */
    @ApiModelProperty("物料仓库关联ID")
    @TableId
    private Long itemWarehouseId;

    /** 物料ID */
    @ApiModelProperty("物料ID")
    private Long itemId;

    /** 物料编码 */
    @ApiModelProperty("物料编码")
    private String itemCode;

    /** 仓库ID */
    @ApiModelProperty("仓库ID")
    private Long warehouseId;

    /** 仓库编码 */
    @ApiModelProperty("仓库编码")
    private String warehouseCode;

    /** 仓位 */
    @ApiModelProperty("仓位")
    private String location;

    /** 安全库存 */
    @ApiModelProperty("安全库存")
    private BigDecimal safetyStock;

    /** 备注 */
    @ApiModelProperty("备注")
    private String remark;

    /** 创建者 */
    @ApiModelProperty("创建者")
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("创建时间")
    private Date createTime;

    /** 更新者 */
    @ApiModelProperty("更新者")
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Date updateTime;



}
