package com.ximai.mes.md.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 客户系人对象 md_client_contact
 *
 * @author yinjinlu
 * @date 2024-01-19
 */
public class MdClientContact extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private String id;

    /** 客户id */
    @Excel(name = "客户编码")
    private String clientCode;

    /** 品牌ID */
    @Excel(name = "品牌ID")
    private Long brandId;

    /** 品牌名称 */
    @Excel(name = "品牌名称")
    private String brandName;

    /** 部门 */
    @Excel(name = "部门")
    private String department;

    /** 职位 */
    @Excel(name = "职位")
    private String position;

    /** 联系人 */
    @Excel(name = "联系人")
    private String contact;

    /** 电话号码 */
    @Excel(name = "电话号码")
    private String tel;

    /** email */
    @Excel(name = "email")
    private String email;

    /** 经营类型 */
    @Excel(name = "经营类型")
    private String businessType;

    /** 工厂代号 */
    @Excel(name = "工厂代号")
    private String factoryCode;

    /** 跟单员 */
    @Excel(name = "跟单员")
    private String merchandiser;

    public void setId(String id)
    {
        this.id = id;
    }

    public String getId()
    {
        return id;
    }
    public void setClientCode(String clientCode)
    {
        this.clientCode = clientCode;
    }

    public String getClientCode()
    {
        return clientCode;
    }
    public void setBrandId(Long brandId)
    {
        this.brandId = brandId;
    }

    public Long getBrandId()
    {
        return brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public void setPosition(String position)
    {
        this.position = position;
    }

    public String getPosition()
    {
        return position;
    }
    public void setContact(String contact)
    {
        this.contact = contact;
    }

    public String getContact()
    {
        return contact;
    }
    public void setTel(String tel)
    {
        this.tel = tel;
    }

    public String getTel()
    {
        return tel;
    }
    public void setEmail(String email)
    {
        this.email = email;
    }

    public String getEmail()
    {
        return email;
    }
    public void setBusinessType(String businessType)
    {
        this.businessType = businessType;
    }

    public String getBusinessType()
    {
        return businessType;
    }
    public void setFactoryCode(String factoryCode)
    {
        this.factoryCode = factoryCode;
    }

    public String getFactoryCode()
    {
        return factoryCode;
    }
    public void setMerchandiser(String merchandiser)
    {
        this.merchandiser = merchandiser;
    }

    public String getMerchandiser()
    {
        return merchandiser;
    }

    public String getDepartment() {
        return department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("clientCode", getClientCode())
            .append("brandId", getBrandId())
            .append("brandName", getBrandName())
            .append("department", getDepartment())
            .append("position", getPosition())
            .append("contact", getContact())
            .append("tel", getTel())
            .append("email", getEmail())
            .append("businessType", getBusinessType())
            .append("factoryCode", getFactoryCode())
            .append("merchandiser", getMerchandiser())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
