package com.ximai.mes.kanban.controller;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ArrayUtil;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.mes.kanban.dto.abnormal.AbnormalMonthStatDto;
import com.ximai.mes.kanban.service.KanbanAbnormalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@Api("看板异常数据接口")
@RestController
@RequestMapping("/kanban/abnormal")
public class KanbanAbnormalController {

    @Autowired
    KanbanAbnormalService kanbanAbnormalService;

    @ApiOperation("当月异常分布数据")
    @PostMapping("/currentMonthStat")
    public AjaxResult<AbnormalMonthStatDto> currentMonthStat() {
        AbnormalMonthStatDto rst = kanbanAbnormalService.currentMonthStat();
        return AjaxResult.success(rst);
    }


}
