package com.ximai.mes.tm.service;

import java.util.List;
import com.ximai.mes.tm.domain.TmToolMaintenanceProcess;

/**
 * 维护保养过程Service接口
 *
 * @author yinjinlu
 * @date 2024-02-01
 */
public interface ITmToolMaintenanceProcessService
{
    /**
     * 查询维护保养过程
     *
     * @param processId 维护保养过程主键
     * @return 维护保养过程
     */
    public TmToolMaintenanceProcess selectTmToolMaintenanceProcessByProcessId(Long processId);

    /**
     * 查询维护保养过程列表
     *
     * @param tmToolMaintenanceProcess 维护保养过程
     * @return 维护保养过程集合
     */
    public List<TmToolMaintenanceProcess> selectTmToolMaintenanceProcessList(TmToolMaintenanceProcess tmToolMaintenanceProcess);

    /**
     * 新增维护保养过程
     *
     * @param tmToolMaintenanceProcess 维护保养过程
     * @return 结果
     */
    public int insertTmToolMaintenanceProcess(TmToolMaintenanceProcess tmToolMaintenanceProcess);

    /**
     * 修改维护保养过程
     *
     * @param tmToolMaintenanceProcess 维护保养过程
     * @return 结果
     */
    public int updateTmToolMaintenanceProcess(TmToolMaintenanceProcess tmToolMaintenanceProcess);

    /**
     * 批量删除维护保养过程
     *
     * @param processIds 需要删除的维护保养过程主键集合
     * @return 结果
     */
    public int deleteTmToolMaintenanceProcessByProcessIds(Long[] processIds);

    /**
     * 删除维护保养过程信息
     *
     * @param processId 维护保养过程主键
     * @return 结果
     */
    public int deleteTmToolMaintenanceProcessByProcessId(Long processId);
}
