package com.ximai.mes.tm.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import com.baomidou.mybatisplus.annotation.TableId;

/**
 * 【请填写功能名称】对象 tm_tool_warehouse_item
 *
 * @author generator
 * @date 2024-03-07
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TmToolWarehouseItem extends BaseEntity {
    private static final long serialVersionUID = 1L;

    public TmToolWarehouseItem(Long toolWarehouseId) {
        this.toolWarehouseId = toolWarehouseId;
    }

    /**
     * 主键id
     */
    @TableId
    private Long toolWarehouseItemId;
    private String toolWarehouseItemCode;

    /**
     * 刀模版入库单表id
     */
    @Excel(name = "刀模版入库单表id")
    private Long toolWarehouseId;

    @TableField(exist = false)
    private Long toolMachinesId;
    /**
     * 入库状态
     */
    @Excel(name = "入库状态")
    private Long warehouse;

    /**
     * 库位
     */
    @Excel(name = "库位")
    private String local;

    /**
     * 入库类型
     */
    @Excel(name = "入库类型")
    private String warehouseDesc;

    /**
     * 台账编号
     */
    @Excel(name = "台账编号")
    private String toolCode;

    /**
     * 台账名称
     */
    @Excel(name = "台账名称")
    private String toolName;

    /**
     * 物料编码
     */
    @Excel(name = "物料编码")
    private String itemCode;

    /**
     * sap物料编码
     */
    @Excel(name = "sap物料编码")
    @TableField(exist = false)
    private String sapItemCode;

    private String itemName;

    @TableField(exist = false)
    private String type;
}
