package com.ximai.mes.restful;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.pro.domain.ProMaterialRequest;
import com.ximai.mes.pro.domain.vo.ProMaterialRequestVo;
import com.ximai.mes.pro.service.IProMaterialRequestService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@RestController
@RequestMapping(value = "/apiPda/material")
public class PdaMaterialRestController extends BaseController {

    @Autowired
    private IProMaterialRequestService proMaterialRequestService;


    @ApiOperation(value = "pda查看领料申请")
//    @RequestMapping(value = "/pdaMaterialcreate", method = RequestMethod.GET)
//    @GetMapping(value = "/pdaMaterialcreate")
    @RequestMapping(value = "/pdaMaterialcreate", method = RequestMethod.GET)
    public TableDataInfo materialCreate(ProMaterialRequestVo proMaterialRequestVo) {

//        ProMaterialRequestVo proMaterialRequestVo = JSON.parseObject(materialJson).toJavaObject(ProMaterialRequestVo.class);

        String applyNo = proMaterialRequestVo.getApplyNo();
        if (Objects.equals(applyNo, "") || StringUtils.isEmpty(applyNo)) {

            QueryWrapper<ProMaterialRequest> requestQueryWrapper = new QueryWrapper<>();
            List<ProMaterialRequestVo> ProMateria = proMaterialRequestService.selectProMaterialRequestLists(requestQueryWrapper);
            List<ProMaterialRequestVo> proMaterialRequestVos1 = new ArrayList<>();
            for (ProMaterialRequestVo pro : ProMateria) {
                if(!pro.getWindCase().equals("Y")){
                    proMaterialRequestVos1.add(pro);
                }
            }
            return getDataTable(proMaterialRequestVos1);
        } else {

            QueryWrapper<ProMaterialRequest> requestQueryWrapper = new QueryWrapper<>();
            requestQueryWrapper.eq(applyNo != null, "p.apply_no", applyNo);
            List<ProMaterialRequestVo> ProMateria = proMaterialRequestService.selectProMaterialRequestLists(requestQueryWrapper);
            List<ProMaterialRequestVo> proMaterialRequestVos1 = new ArrayList<>();
            for (ProMaterialRequestVo pro : ProMateria) {
                if(!pro.getWindCase().equals("Y")) {
                    proMaterialRequestVos1.add(pro);
                }
            }
            return getDataTable(proMaterialRequestVos1);
        }
    }


}
