package com.ximai.mes.remote.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang.time.DateFormatUtils;

import java.text.DateFormat;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 工单对象 ProWorkorderErpQuery
 *
 * @date 2024-10-18
 */
@Data
public class ProWorkorderErpQuery extends ErpPageParams
{
    @ApiModelProperty("审核码")
    @JsonProperty("ta013")
    private String verifyStatus;

    @ApiModelProperty("工单单别")
    @JsonProperty("ta001")
    private String orderSource;

    @JsonProperty("neUdf07")
    @ApiModelProperty("同步标识状态-不等于")
    private String neSyncMark;

    @ApiModelProperty("工单单号")
    @JsonProperty("ta002")
    private String workorderCode;

    @JsonFormat(pattern = "yyyyMMddHHmmssSSS")
    @ApiModelProperty("创建日期")
    private Date gtEqCreateDate;
    @JsonFormat(pattern = "yyyyMMddHHmmssSSS")
    @ApiModelProperty("修改日期")
    private Date gtEqModiDate;
}
