package com.ximai.mes.remote.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ximai.mes.config.EmptyStringToLongDeserializer;
import com.ximai.mes.config.TrimStringDeserializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 物料对象 MdItemErpDto
 *
 * @date 2024-10-18
 */
@Data
public class MdItemErpDto
{
    private static final long serialVersionUID = 1L;

    @JsonProperty("mb001")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("物料/产品编码")
    private String itemCode;

    @JsonProperty("mb002")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("物料/产品名称")
    private String itemName;

    @JsonProperty("mb003")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("规格型号")
    private String specification;

    @JsonProperty("mb004")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("计量单位名称")
    private String unitOfMeasure;

    @JsonProperty("mb005")
    @JsonDeserialize(using = EmptyStringToLongDeserializer.class)
    @ApiModelProperty("物料/产品分类ID")
    private Long itemTypeId;

//    @JsonProperty("mb005")
//    @JsonDeserialize(using = TrimStringDeserializer.class)
//    @ApiModelProperty("物料/产品分类")
//    private String itemTypeName;

    @JsonProperty("udf07")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("内部图号")
    private String inDrawingNo;

    @JsonProperty("mb029")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("客户图号")
    private String customerDrawingNo;

    @JsonProperty("udf01")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("客户品号")
    private String customerProNo;

    @JsonProperty("mb017")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("主要仓库")
    private String mainWarehouseId;

    /**
     * 1:已核准、2:尚待核准、3:不准交易
     */
    @JsonProperty("mb109")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("核准状态")
    private String verifyStatus;

    @JsonProperty("mb028")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    @ApiModelProperty("备注")
    private String remark;

    @JsonProperty("createDate")
    @JsonFormat(pattern = "yyyyMMddHHmmssSSS")
    @ApiModelProperty("创建时间")
    private Date erpCreateTime;

    @JsonProperty("modiDate")
    @JsonFormat(pattern = "yyyyMMddHHmmssSSS")
    @ApiModelProperty("修改时间")
    private Date erpUpdateTime;

    @JsonProperty("invmcs")
    @ApiModelProperty("关联仓库")
    private List<MdItemWarehouseErpDto> warehouseList;
}
