package com.ximai.mes.qc.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Data;

/**
 * 检测模板对象 qc_template
 *
 * @date 2022-05-17
 */
@Data
public class QcTemplate extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 检测模板ID
     */
    @TableId
    private Long id;

    /**
     * 检测模板编号
     */
    @Excel(name = "检测模板编号")
    private String templateCode;

    /**
     * 检测模板名称
     */
    @Excel(name = "检测模板名称")
    private String templateName;

    /**
     * 检测种类
     */
    @Excel(name = "检测种类")
    private String qcTypes;

    /**
     * 用来传递检测种类参数
     */
    private String[] qcTypesParam;

    /**
     * 物料ID
     */
    @TableField(exist = false)
    private Long itemId;

    @TableField(exist = false)
    private Long processId;

    /**
     * 是否启用
     */
    @Excel(name = "是否启用")
    private String enableFlag;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;

    /*
     * templateType
     * 模板类型  0:IPQC 1:IQC
     */
    @Excel(name = "模板类型 0:IPQC  1:IQC")
    private Integer qcType;

}
