package com.ximai.mes.pro.service.task;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.GanttTask;
import com.ximai.mes.pro.domain.ProFeedback;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.pro.domain.task.WorkorderScheduleParams;
import com.ximai.mes.pro.domain.vo.ProPackagePrintResult;
import com.ximai.mes.pro.domain.vo.ProTaskQuery;
import com.ximai.mes.pro.domain.vo.ProTaskVo;
import com.ximai.mes.pro.domain.vo.ProWorkorderVo;
import com.ximai.mes.pro.domain.vo.proWorkOrder.WorkorderPackagePrint;
import com.ximai.mes.pro.domain.vo.task.FeedbackPackageAddParams;
import com.ximai.mes.pro.domain.vo.task.FeedbackPackageInfo;
import com.ximai.mes.pro.domain.vo.task.FeedbackPackageQueryParams;
import com.ximai.mes.pro.dto.task.ProTaskLinkFile;
import com.ximai.mes.tm.domain.vo.TmToolRequestItemVo;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * 生产任务Service接口
 *
 * @date 2022-05-14
 */
public interface IProTaskService {
    /**
     * 查询生产任务
     *
     * @param taskId 生产任务主键
     * @return 生产任务
     */
    ProTask selectProTaskByTaskId(Long taskId);


    ProTask getIpqcInsertInfo(String arrangeCode, Long workorderId, Long processId);

    List<TmToolRequestItemVo> getToolOnProcessTemplate(ProTaskWorkunit proTaskWorkunit);

    /**
     * 查询生产任务
     *
     * @param taskCode 生产任务主键
     * @return 生产任务
     */
    ProTask selectProTaskByTaskCode(String taskCode);

    /**
     * 查询生产任务列表
     *
     * @param proTask 生产任务
     * @return 生产任务集合
     */
    List<ProTask> selectProTaskList(ProTask proTask);

    ProTask selectByArrangeCodeAndProcessId(String arrangeCode, Long processId);

    List<ProTask> selectProTaskDetailList(ProTask proTask);

    /**
     * 查询生产任务列表
     *
     * @param proTask 生产任务
     * @return 生产任务集合
     */
    List<ProTask> selectProTaskJoinTaskWorkUnit(QueryWrapper<ProTask> proTask);

    /**
     * 查询生产任务列表，关联工单表
     *
     * @param proTask 生产任务
     * @return 生产任务集合
     */
    List<ProTaskVo> selectProTaskJoinWorkorder(QueryWrapper<ProTask> proTask);

    /**
     * 新增生产任务
     *
     * @param proTask 生产任务
     * @return 结果
     */
    int insertProTask(ProTask proTask);

    /**
     * 新增生产任务
     *
     * @param proTask 生产任务
     * @return 结果
     */
    int createProTask(ProTask proTask);


    /**
     * 修改生产任务
     *
     * @param proTask 生产任务
     * @return 结果
     */
    int updateProTask(ProTask proTask);

    /**
     * 批量删除生产任务
     *
     * @param taskIds 需要删除的生产任务主键集合
     * @return 结果
     */
    int deleteProTaskByTaskIds(Long[] taskIds);

    /**
     * 删除生产任务信息
     *
     * @param taskId 生产任务主键
     * @return 结果
     */
    int deleteProTaskByTaskId(Long taskId);

    /**
     * 新增任务单/合并任务单
     */
    int insertProTasks(Long[] workorderIds);

    GanttTask getGanttTaskList();

    void setStatus(Long taskId, String issuegenerated);

    List<String> getWorkorderNos(Long taskId);

    List<Map<String, String>> listMdItemByWorkUnit(Long id);

    /**
     * 报工处理
     *
     * @param feedback
     */
    List<ProPackagePrintResult> feedBack(ProFeedback feedback);


    /**
     * 派工任务状态修改
     *
     * @param proTask
     */
    void changeStatus(ProTask proTask);

    /**
     * 手动排产
     */
    void manualSchedule(ProTaskVo proTaskVo);

    ProTaskWorkunit splitTask(ProTaskVo proTaskVo, Integer type);

    @Transactional
    void taskWorkunitSplit(ProTaskVo proTaskVo);

    @Transactional
    void copyTask(ProTask proTaskVo);

    List<ProTask> selectListByQw(QueryWrapper<ProTask> proTaskQueryWrapper);

    /**
     * 工单排产
     */
    void schedule(List<WorkorderScheduleParams> workorderScheduleParams);

    /**
     * 查询设备关联最新任务号
     *
     * @param taskQuery
     * @return
     */
    List<ProTask> selectEquipmentNewestTask(QueryWrapper<ProTask> taskQuery);

    List<ProTask> selectProTaskByWorkorderCode(String workorderCode);

    void closeObj(List<ProTaskVo> taskIds);


    ProTask getNextTaskByTaskId(Long taskId);

    ProTask selectBaseById(Long taskId);

    List<ProTask> getTaskList(ProTaskQuery proTask);

    /**
     * 查询任务关联附件
     * @param proTask
     * @return
     */
    List<ProTaskLinkFile> getTaskLinkFile(ProTaskQuery proTask);


}
