package com.ximai.mes.pro.service.impl.proWorkOrder;

import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessItem;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkOrderProcessItemMapper;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderProcessItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * 生产工单工序物料Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
@Service
public class ProWorkOrderProcessItemServiceImpl implements IProWorkOrderProcessItemService {
    @Autowired
    private ProWorkOrderProcessItemMapper proWorkOrderProcessItemMapper;

    @Override
    public void deleteByWorkorderCode(String workorderCode) {
        proWorkOrderProcessItemMapper.deleteByWorkorderCode(workorderCode);

    }

    @Override
    public void deleteByWorkorderProcessIds(Set<Long> workorderProcessIds) {
        ArrayList<Long> longs = new ArrayList<>(workorderProcessIds);
        StringBuilder sb = new StringBuilder();
        for (Long aLong : longs) {
            sb.append(aLong).append(',');
        }
        String substring = sb.substring(0, sb.length() - 1);
        proWorkOrderProcessItemMapper.deleteByWorkorderProcessIds(substring);
    }


    /**
     * 查询生产工单工序物料
     *
     * @param workorderProcessItemId 生产工单工序物料主键
     * @return 生产工单工序物料
     */
    @Override
    public ProWorkOrderProcessItem selectProWorkOrderProcessItemByWorkorderProcessItemId(Long workorderProcessItemId) {
        return proWorkOrderProcessItemMapper.selectProWorkOrderProcessItemByWorkorderProcessItemId(workorderProcessItemId);
    }

    /**
     * 查询生产工单工序物料列表
     *
     * @param proWorkOrderProcessItem 生产工单工序物料
     * @return 生产工单工序物料
     */
    @Override
    public List<ProWorkOrderProcessItem> selectProWorkOrderProcessItemList(ProWorkOrderProcessItem proWorkOrderProcessItem) {
        return proWorkOrderProcessItemMapper.selectProWorkOrderProcessItemList(proWorkOrderProcessItem);
    }

    /**
     * 新增生产工单工序物料
     *
     * @param proWorkOrderProcessItem 生产工单工序物料
     * @return 结果
     */
    @Override
    public int insertProWorkOrderProcessItem(ProWorkOrderProcessItem proWorkOrderProcessItem) {
        proWorkOrderProcessItem.createAction();
        return proWorkOrderProcessItemMapper.insertProWorkOrderProcessItem(proWorkOrderProcessItem);
    }

    /**
     * 修改生产工单工序物料
     *
     * @param proWorkOrderProcessItem 生产工单工序物料
     * @return 结果
     */
    @Override
    public int updateProWorkOrderProcessItem(ProWorkOrderProcessItem proWorkOrderProcessItem) {
        proWorkOrderProcessItem.updateAction();
        return proWorkOrderProcessItemMapper.updateProWorkOrderProcessItem(proWorkOrderProcessItem);
    }

    /**
     * 批量删除生产工单工序物料
     *
     * @param workorderProcessItemIds 需要删除的生产工单工序物料主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderProcessItemByWorkorderProcessItemIds(Long[] workorderProcessItemIds) {
        return proWorkOrderProcessItemMapper.deleteProWorkOrderProcessItemByWorkorderProcessItemIds(workorderProcessItemIds);
    }

    /**
     * 删除生产工单工序物料信息
     *
     * @param workorderProcessItemId 生产工单工序物料主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderProcessItemByWorkorderProcessItemId(Long workorderProcessItemId) {
        return proWorkOrderProcessItemMapper.deleteProWorkOrderProcessItemByWorkorderProcessItemId(workorderProcessItemId);
    }
}
