package com.ximai.mes.pro.service;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProWorkOrderArrangeRule;
import com.ximai.mes.pro.domain.vo.proWorkOrder.ArrangeRuleDto;

/**
 * 编排单对照表Service接口
 *
 * @author generator
 * @date 2024-03-14
 */
public interface IProWorkOrderArrangeRuleService
{
    /**
     * 查询编排单对照表
     *
     * @param arrangeRuleId 编排单对照表主键
     * @return 编排单对照表
     */
    public ProWorkOrderArrangeRule selectProWorkOrderArrangeRuleByArrangeRuleId(Long arrangeRuleId);

    /**
     * 查询编排单对照表列表
     *
     * @param proWorkOrderArrangeRule 编排单对照表
     * @return 编排单对照表集合
     */
    public List<ProWorkOrderArrangeRule> selectProWorkOrderArrangeRuleList(ProWorkOrderArrangeRule proWorkOrderArrangeRule);

    /**
     * 查询按产品分类、工序分组后的需验证规则属性
     *
     * @param query 编排单对照表
     * @return 编排单对照表集合 返回key=工单分类+工序的规则配置
     */
    public Map<String, ArrangeRuleDto> selectProWorkOrderArrangeRule(QueryWrapper<ProWorkOrderArrangeRule> query);

    /**
     * 新增编排单对照表
     *
     * @param proWorkOrderArrangeRule 编排单对照表
     * @return 结果
     */
    public int insertProWorkOrderArrangeRule(ProWorkOrderArrangeRule proWorkOrderArrangeRule);

    /**
     * 修改编排单对照表
     *
     * @param proWorkOrderArrangeRule 编排单对照表
     * @return 结果
     */
    public int updateProWorkOrderArrangeRule(ProWorkOrderArrangeRule proWorkOrderArrangeRule);

    /**
     * 批量删除编排单对照表
     *
     * @param arrangeRuleIds 需要删除的编排单对照表主键集合
     * @return 结果
     */
    public int deleteProWorkOrderArrangeRuleByArrangeRuleIds(Long[] arrangeRuleIds);

    /**
     * 删除编排单对照表信息
     *
     * @param arrangeRuleId 编排单对照表主键
     * @return 结果
     */
    public int deleteProWorkOrderArrangeRuleByArrangeRuleId(Long arrangeRuleId);
}
