package com.ximai.mes.pro.service;

import java.util.List;
import com.ximai.mes.pro.domain.ProMaterialUsageRecord;

/**
 * 生产物料扣减Service接口
 *
 * @author mengcheng
 * @date 2024-01-20
 */
public interface IProMaterialUsageRecordService
{
    /**
     * 查询生产物料扣减
     *
     * @param recordId 生产物料扣减主键
     * @return 生产物料扣减
     */
    public ProMaterialUsageRecord selectProMaterialUsageRecordByRecordId(Long recordId);

    /**
     * 查询生产物料扣减列表
     *
     * @param proMaterialUsageRecord 生产物料扣减
     * @return 生产物料扣减集合
     */
    public List<ProMaterialUsageRecord> selectProMaterialUsageRecordList(ProMaterialUsageRecord proMaterialUsageRecord);

    /**
     * 新增生产物料扣减
     *
     * @param proMaterialUsageRecord 生产物料扣减
     * @return 结果
     */
    public int insertProMaterialUsageRecord(ProMaterialUsageRecord proMaterialUsageRecord);

    /**
     * 修改生产物料扣减
     *
     * @param proMaterialUsageRecord 生产物料扣减
     * @return 结果
     */
    public int updateProMaterialUsageRecord(ProMaterialUsageRecord proMaterialUsageRecord);

    /**
     * 批量删除生产物料扣减
     *
     * @param recordIds 需要删除的生产物料扣减主键集合
     * @return 结果
     */
    public int deleteProMaterialUsageRecordByRecordIds(Long[] recordIds);

    /**
     * 删除生产物料扣减信息
     *
     * @param recordId 生产物料扣减主键
     * @return 结果
     */
    public int deleteProMaterialUsageRecordByRecordId(Long recordId);
}
