package com.ximai.mes.pro.mapper.task;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.task.ProTaskAssistProcess;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 工序任务外协关系Mapper接口
 *
 * @author generator
 * @date 2024-03-29
 */
public interface ProTaskAssistProcessMapper extends BaseMapper<ProTaskAssistProcess> {
    /**
     * 查询工序任务外协关系
     *
     * @param id 工序任务外协关系主键
     * @return 工序任务外协关系
     */
    ProTaskAssistProcess selectProTaskAssistProcessById(Long id);

    /**
     * 新增工序任务外协关系
     *
     * @param proTaskAssistprocess 工序任务外协关系
     * @return 结果
     */
    int insertProTaskAssistprocess(ProTaskAssistProcess proTaskAssistprocess);

    /**
     * 修改工序任务外协关系
     *
     * @param proTaskAssistprocess 工序任务外协关系
     * @return 结果
     */
    int updateProTaskAssistProcess(ProTaskAssistProcess proTaskAssistprocess);

    /**
     * 删除工序任务外协关系
     *
     * @param id 工序任务外协关系主键
     * @return 结果
     */
    int deleteProTaskAssistProcessById(Long id);

    /**
     * 批量删除工序任务外协关系
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProTaskAssistProcessByIds(Long[] ids);

    ProTaskAssistProcess selectProTaskAssistProcessByObj(ProTaskAssistProcess proTaskAssistProcesses);

    @Select("SELECT\n" +
            "\tptw.task_workunit_id,-- \tpf.quantity_qualify,\n" +
            "-- \tptw.quantity\n" +
            "\tCOALESCE ( ptw.quantity, 0 ) AS ptwQuantity, \n" +
            "\t\tptap.*\n" +
            "\t\n" +
            "FROM\n" +
            "\tpro_task_assist_process ptap\n" +
            "\tLEFT JOIN pro_task_workunit ptw ON ptap.task_workunit_id = ptw.task_workunit_id\n" +
            "\tLEFT JOIN ( SELECT task_workunit_id, sum( COALESCE ( quantity_qualify, 0 ) ) quantity_qualify FROM pro_feedback GROUP BY task_workunit_id ) pf ON ptw.task_workunit_id = pf.task_workunit_id \n" +
            "WHERE\n" +
            "\tptap.assist_process_code = #{assistProcessCode} \n" +
            "\tAND COALESCE ( ptw.quantity, 0 ) > pf.quantity_qualify \n" +
            "AND ptap.close_type = 0 AND ptap.delete_state = 0")
    ProTaskAssistProcess selectTaskAssistProcessByTwCode(@Param("assistProcessCode") String assistProcessCode);

    @Select(value = "select * from pro_task_assist_process\n" +
            "${ew.customSqlSegment}")
    List<ProTaskAssistProcess> selectListByQw(@Param("ew") QueryWrapper<ProTaskAssistProcess> query);


    @Select(value = "select " +
            "       ptap.workorder_code,\n" +
            "       ptw.task_workunit_id,\n" +
            "       pt.task_id,\n" +
            "       ptap.assist_process_code,\n" +
            "       ptap.assist_process_item_code,\n" +
            "       ptw.schedule_start_date,\n" +
            "       ptap.schedule_end_date,\n" +
            "       pw.product_code,\n" +
            "       pw.product_name,\n" +
            "       pp.process_name,\n" +
            "       ptw.workunit_id,\n" +
            "       ptap.quantity\n" +
            "from pro_task_assist_process ptap\n" +
            "         inner join pro_task_workunit ptw on ptap.task_workunit_id = ptw.task_workunit_id\n" +
            "         inner join pro_task pt on pt.task_id = pt.task_id\n" +
            "         left join pro_workorder pw on ptap.workorder_id = pw.workorder_id\n" +
            "         left join pro_process pp on ptap.process_id = pp.process_id\n" +
            " ${ew.customSqlSegment}")
    List<ProTaskAssistProcess> getAssistProcesslist(@Param("ew") QueryWrapper<ProTaskAssistProcess> proTaskAssistProcessQueryWrapper);
}
