package com.ximai.mes.pro.domain.vo.task;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 任务工作查询单元对象
 *
 * @author zht
 * @date 2024-01-23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProTaskWorkunitQuery extends BaseEntity {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty("工序名称")
    private String processName;

    @ApiModelProperty("编排单号")
    private String arrangeCode;

    @Excel(name = "任务编号")
    private String taskCode;

    @ApiModelProperty("派工任务ID")
    private Long taskWorkunitId;

    @ApiModelProperty("任务ID")
    private Long taskId;

    @ApiModelProperty("产品物料编码")
    private String itemCode;

    @ApiModelProperty("产品物料名称")
    private String itemName;

    @ApiModelProperty("大于排产数量")
    private BigDecimal gtQuantity;

    @ApiModelProperty("生产任务状态，UN_ASSIGN:未下达,PREPARE:未开工,BEGINNING:已开工,PAUSE:暂停,ERROR_STOP:异常停工,FINISHED:完工")
    private String[] statusArr;

    @ApiModelProperty("计划开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleStartDateFrom;

    @ApiModelProperty("计划开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleStartDateTo;

    @ApiModelProperty("计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleEndDateFrom;

    @ApiModelProperty("计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleEndDateTo;

    @ApiModelProperty("工作中心Id")
    private Long workCenterId;

    @ApiModelProperty("工厂Id")
    private Long workshopId;

    @ApiModelProperty("工作单元Id")
    private Long workunitId;

    @ApiModelProperty("工作单元Id不等于")
    private Long neWorkunitId;

    @ApiModelProperty("工作单元编码")
    private String workunitCode;

    @ApiModelProperty("工作单元名称")
    private String workunitName;

    private String workorderCode;

    @ApiModelProperty("是否委外,1:是，0:否")
    private Integer outsourced;

}
