package com.ximai.mes.pro.domain.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class ProWorkorderVo1 {
    /** 工单ID */
    private Long workorderId;

    /** 工艺路线ID */
    private Long routeId;

    private String routeCode;

    /** 工艺路线 */
    @Excel(name = "工艺路线")
    private String routeName;

    /** 工单编码 */
    @Excel(name = "工单编码")
    private String workorderCode;

    /** 工单名称 */
    @Excel(name = "工单名称")
    private String workorderName;

    /** 工单类型 */
    @Excel(name = "工单类型")
    private String workorderType;

    /** 来源类型 */
    @Excel(name = "来源类型")
    private String orderSource;

    /** 来源单据 */
    @Excel(name = "来源单据")
    private String sourceCode;

    /** 产品ID */
    @Excel(name = "产品ID")
    private Long productId;

    /** 产品编号 */
    @Excel(name = "产品编号")
    private String productCode;

    /** 产品名称 */
    @Excel(name = "产品名称")
    private String productName;

    /** 规格型号 */
    @Excel(name = "规格型号")
    private String productSpc;

    /** 单位 */
    @Excel(name = "单位")
    private String unitOfMeasure;

    /** 编排单号 */
    private String arrangeCode;

    /** 批次号 */
    @Excel(name = "批次号")
    private String batchCode;

    /** 生产数量 */
    @Excel(name = "生产数量")
    private BigDecimal quantity;

    /** 已生产数量 */
    @Excel(name = "已生产数量")
    private BigDecimal quantityProduced;

    /** 调整数量 */
    @Excel(name = "调整数量")
    private BigDecimal quantityChanged;

    /** 已排产数量 */
    @Excel(name = "已排产数量")
    private BigDecimal quantityScheduled;

    /** 客户ID */
    @Excel(name = "客户ID")
    private Long clientId;

    /** 物料id */
    @Excel(name = "物料id")
    private Long itemId;

    /** 客户编码 */
    @Excel(name = "客户编码")
    private String clientCode;

    /** 客户名称 */
    @Excel(name = "客户名称")
    private String clientName;

    /** 供应商ID */
    @Excel(name = "供应商ID")
    private Long vendorId;

    /** 供应商编号 */
    @Excel(name = "供应商编号")
    private String vendorCode;

    /** 供应商名称 */
    @Excel(name = "供应商名称")
    private String vendorName;


    /** 需求日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "需求日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date requestDate;

    /** 完成时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "完成时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date finishDate;

    /** 单据状态 */
    @Excel(name = "单据状态")
    private String status;

    /** 预留字段1 */
    private String attr1;

    /** 预留字段2 */
    private String attr2;

    /** 预留字段3 */
    private Long attr3;

    /** 预留字段4 */
    private Long attr4;

    @TableField(exist = false)
    private String itemTypeName;


    /** 是否急单 */
    @Excel(name = "是否急单")
    private String  rushOrder;

}
