package com.ximai.mes.pro.domain.productionRequest;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 量产申请BOM对象 pro_production_request_bom
 *
 * @author chicheng.li
 * @date 2024-01-22
 */
public class ProProductionRequestBom extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** ID */
    private Long bomItemId;

    /** 量产申请单ID */
    @Excel(name = "量产申请单ID")
    private Long productionRequestId;

    /** 物料ID */
    @Excel(name = "物料ID")
    private Long itemId;

    private String itemName;

    /** 组件数量 */
    @Excel(name = "组件数量")
    private Long quantity;

    /** 计量单位 */
    @Excel(name = "计量单位")
    private String unitOfMeasure;

    /** 报废百分比 */
    @Excel(name = "报废百分比")
    private Long scrapPercentage;

    /** 替代组 */
    @Excel(name = "替代组")
    private String alternativeGroup;

    /** 替代优先级 */
    @Excel(name = "替代优先级")
    private Long alternativePriorities;

    /** 策略 */
    @Excel(name = "策略")
    private String alternativeStrategy;

    /** 使用概率 */
    @Excel(name = "使用概率")
    private Long alternativeProbability;

    /** BOM行备注 */
    @Excel(name = "BOM行备注")
    private String bomItemRemark;

    /** 物料备注 */
    @Excel(name = "物料备注")
    private String itemRemark;

    public void setBomItemId(Long bomItemId)
    {
        this.bomItemId = bomItemId;
    }

    public Long getBomItemId()
    {
        return bomItemId;
    }
    public void setProductionRequestId(Long productionRequestId)
    {
        this.productionRequestId = productionRequestId;
    }

    public Long getProductionRequestId()
    {
        return productionRequestId;
    }
    public void setItemId(Long itemId)
    {
        this.itemId = itemId;
    }

    public Long getItemId()
    {
        return itemId;
    }
    public void setQuantity(Long quantity)
    {
        this.quantity = quantity;
    }

    public Long getQuantity()
    {
        return quantity;
    }
    public void setUnitOfMeasure(String unitOfMeasure)
    {
        this.unitOfMeasure = unitOfMeasure;
    }

    public String getUnitOfMeasure()
    {
        return unitOfMeasure;
    }
    public void setScrapPercentage(Long scrapPercentage)
    {
        this.scrapPercentage = scrapPercentage;
    }

    public Long getScrapPercentage()
    {
        return scrapPercentage;
    }
    public void setAlternativeGroup(String alternativeGroup)
    {
        this.alternativeGroup = alternativeGroup;
    }

    public String getAlternativeGroup()
    {
        return alternativeGroup;
    }
    public void setAlternativePriorities(Long alternativePriorities)
    {
        this.alternativePriorities = alternativePriorities;
    }

    public Long getAlternativePriorities()
    {
        return alternativePriorities;
    }
    public void setAlternativeStrategy(String alternativeStrategy)
    {
        this.alternativeStrategy = alternativeStrategy;
    }

    public String getAlternativeStrategy()
    {
        return alternativeStrategy;
    }
    public void setAlternativeProbability(Long alternativeProbability)
    {
        this.alternativeProbability = alternativeProbability;
    }

    public Long getAlternativeProbability()
    {
        return alternativeProbability;
    }
    public void setBomItemRemark(String bomItemRemark)
    {
        this.bomItemRemark = bomItemRemark;
    }

    public String getBomItemRemark()
    {
        return bomItemRemark;
    }
    public void setItemRemark(String itemRemark)
    {
        this.itemRemark = itemRemark;
    }

    public String getItemRemark()
    {
        return itemRemark;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("bomItemId", getBomItemId())
            .append("productionRequestId", getProductionRequestId())
            .append("itemId", getItemId())
            .append("quantity", getQuantity())
            .append("unitOfMeasure", getUnitOfMeasure())
            .append("scrapPercentage", getScrapPercentage())
            .append("alternativeGroup", getAlternativeGroup())
            .append("alternativePriorities", getAlternativePriorities())
            .append("alternativeStrategy", getAlternativeStrategy())
            .append("alternativeProbability", getAlternativeProbability())
            .append("bomItemRemark", getBomItemRemark())
            .append("itemRemark", getItemRemark())
            .toString();
    }
}
