package com.ximai.mes.pro.domain.proWorkOrder;

import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * dto排版记录对象 pro_work_order_dto_record
 *
 * @author generator
 * @date 2024-05-18
 */
@Data
public class ProWorkOrderDtaRecord extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 流水号
     */
    @TableId
    private Long id;

    /**
     * 工单id
     */
    @Excel(name = "工单id")
    private Long workorderId;

    /**
     * 工单编号
     */
    @Excel(name = "工单编号")
    private String workorderCode;

    /**
     * 销售id
     */
    @Excel(name = "销售编号")
    private String saleCode;

    /**
     * 物料id
     */
    @Excel(name = "物料id")
    private Long itemId;

    /**
     * sap物料编码
     */
    @Excel(name = "sap物料编码")
    private String sapItemCode;

    /**
     * 物料名称
     */
    @Excel(name = "物料名称")
    private String itemName;

    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;
}
