package com.ximai.mes.pro.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.ProWorkOrderArrangeRule;
import com.ximai.mes.pro.service.IProWorkOrderArrangeRuleService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 编排单对照表Controller
 *
 * @author generator
 * @date 2024-03-14
 */
@RestController
@RequestMapping("/mes/pro/ProWorkOrderArrangeRule")
public class ProWorkOrderArrangeRuleController extends BaseController {
    @Autowired
    private IProWorkOrderArrangeRuleService proWorkOrderArrangeRuleService;

    /**
     * 查询编排单对照表列表
     */
    @PreAuthorize("@ss.hasPermi('pro:ProWorkOrderArrangeRule:list')")
    @GetMapping("/list")
    @ApiOperation("查询编排单对照表列表")
    public TableDataInfo list(ProWorkOrderArrangeRule proWorkOrderArrangeRule) {
        startPage();
        List<ProWorkOrderArrangeRule> list = proWorkOrderArrangeRuleService.selectProWorkOrderArrangeRuleList(proWorkOrderArrangeRule);
        return getDataTable(list);
    }


    /**
     * 获取编排单对照表详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:ProWorkOrderArrangeRule:query')")
    @GetMapping(value = "/{arrangeRuleId}")
    public AjaxResult getInfo(@PathVariable("arrangeRuleId") Long arrangeRuleId) {
        return AjaxResult.success(proWorkOrderArrangeRuleService.selectProWorkOrderArrangeRuleByArrangeRuleId(arrangeRuleId));
    }

    /**
     * 新增编排单对照表
     */
    @PreAuthorize("@ss.hasPermi('pro:ProWorkOrderArrangeRule:add')")
    @Log(title = "编排单对照表", businessType = BusinessType.INSERT)
    @PostMapping
    @ApiOperation("新增编排单对照表")
    public AjaxResult add(@RequestBody ProWorkOrderArrangeRule proWorkOrderArrangeRule) {
        return toAjax(proWorkOrderArrangeRuleService.insertProWorkOrderArrangeRule(proWorkOrderArrangeRule));
    }

    /**
     * 修改编排单对照表
     */
    @PreAuthorize("@ss.hasPermi('pro:ProWorkOrderArrangeRule:edit')")
    @Log(title = "编排单对照表", businessType = BusinessType.UPDATE)
    @PutMapping
    @ApiOperation("修改编排单对照表")
    public AjaxResult edit(@RequestBody ProWorkOrderArrangeRule proWorkOrderArrangeRule) {
        return toAjax(proWorkOrderArrangeRuleService.updateProWorkOrderArrangeRule(proWorkOrderArrangeRule));
    }

    /**
     * 删除编排单对照表
     */
    @PreAuthorize("@ss.hasPermi('pro:ProWorkOrderArrangeRule:remove')")
    @Log(title = "编排单对照表", businessType = BusinessType.DELETE)
    @DeleteMapping("/{arrangeRuleIds}")
    public AjaxResult remove(@PathVariable Long[] arrangeRuleIds) {
        return toAjax(proWorkOrderArrangeRuleService.deleteProWorkOrderArrangeRuleByArrangeRuleIds(arrangeRuleIds));
    }
}
