package com.ximai.mes.pro.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.ProScheduleSetupRuleVal;
import com.ximai.mes.pro.service.IProScheduleSetupRuleValService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 排产换型属性值信息Controller
 *
 * @author generator
 * @date 2024-04-01
 */
@RestController
@RequestMapping("/pro/scheduleSetupRuleVal")
public class ProScheduleSetupRuleValController extends BaseController
{
    @Autowired
    private IProScheduleSetupRuleValService proScheduleSetupRuleValService;

    /**
     * 查询排产换型属性值信息列表
     */
    @PreAuthorize("@ss.hasPermi('pro:scheduleSetupRuleVal:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProScheduleSetupRuleVal proScheduleSetupRuleVal)
    {
        startPage();
        List<ProScheduleSetupRuleVal> list = proScheduleSetupRuleValService.selectProScheduleSetupRuleValList(proScheduleSetupRuleVal);
        return getDataTable(list);
    }

    /**
     * 获取排产换型属性值信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:scheduleSetupRuleVal:query')")
    @GetMapping(value = "/{ruleValId}")
    public AjaxResult getInfo(@PathVariable("ruleValId") Long ruleValId)
    {
        return AjaxResult.success(proScheduleSetupRuleValService.selectProScheduleSetupRuleValByRuleValId(ruleValId));
    }

    /**
     * 新增排产换型属性值信息
     */
    @PreAuthorize("@ss.hasPermi('pro:scheduleSetupRuleVal:add')")
    @Log(title = "排产换型属性值信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProScheduleSetupRuleVal proScheduleSetupRuleVal)
    {
        return toAjax(proScheduleSetupRuleValService.insertProScheduleSetupRuleVal(proScheduleSetupRuleVal));
    }

    /**
     * 修改排产换型属性值信息
     */
    @PreAuthorize("@ss.hasPermi('pro:scheduleSetupRuleVal:edit')")
    @Log(title = "排产换型属性值信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProScheduleSetupRuleVal proScheduleSetupRuleVal)
    {
        return toAjax(proScheduleSetupRuleValService.updateProScheduleSetupRuleVal(proScheduleSetupRuleVal));
    }

    /**
     * 删除排产换型属性值信息
     */
    @PreAuthorize("@ss.hasPermi('pro:scheduleSetupRuleVal:remove')")
    @Log(title = "排产换型属性值信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ruleValIds}")
    public AjaxResult remove(@PathVariable Long[] ruleValIds)
    {
        return toAjax(proScheduleSetupRuleValService.deleteProScheduleSetupRuleValByRuleValIds(ruleValIds));
    }
}
