package com.ximai.mes.od.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.od.domain.OdSalesOrderDetailItem;
import com.ximai.mes.od.service.IOdSalesOrderDetailItemService;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 【请填写功能名称】Controller
 *
 * @author generator
 * @date 2024-02-18
 */
@RestController
@AllArgsConstructor
@RequestMapping("/md/odSalesOrderDetailItem")
public class OdSalesOrderDetailItemController {

    private final IOdSalesOrderDetailItemService odSalesOrderDetailItemService;

    /**
     * 查询客户产品对照列表
     */
    @PostMapping("/page")
    @PreAuthorize("@ss.hasPermi('md:clientItem:list')")
    public AjaxResult page(@RequestBody Map<String, Object> params) {
        return AjaxResult.success(odSalesOrderDetailItemService.page(params));
    }

    /**
     * 查询【请填写功能名称】列表
     */
    @GetMapping("/list")
    @PreAuthorize("@ss.hasPermi('md:odSalesOrderDetailItem:list')")
    public AjaxResult list(OdSalesOrderDetailItem odSalesOrderDetailItem) {
        List<OdSalesOrderDetailItem> list = odSalesOrderDetailItemService.selectList(odSalesOrderDetailItem);
        return AjaxResult.success(list);
    }

    /**
     * 获取【请填写功能名称】详细信息
     */
    @GetMapping("/{id}")
    @PreAuthorize("@ss.hasPermi('md:odSalesOrderDetailItem:query')")
    public AjaxResult get(@PathVariable("id") Long id) {
        return AjaxResult.success(odSalesOrderDetailItemService.selectById(id));
    }

    /**
     * 新增【请填写功能名称】
     */
    @PostMapping
    @PreAuthorize("@ss.hasPermi('md:odSalesOrderDetailItem:add')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    public AjaxResult add(@RequestBody OdSalesOrderDetailItem odSalesOrderDetailItem) {
        return odSalesOrderDetailItemService.insert(odSalesOrderDetailItem) ? AjaxResult.success() : AjaxResult.error();
    }

    /**
     * 修改【请填写功能名称】
     */
    @PutMapping
    @PreAuthorize("@ss.hasPermi('md:odSalesOrderDetailItem:edit')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    public AjaxResult edit(@RequestBody OdSalesOrderDetailItem odSalesOrderDetailItem) {
        return odSalesOrderDetailItemService.update(odSalesOrderDetailItem) ? AjaxResult.success() : AjaxResult.error();
    }

    /**
     * 删除【请填写功能名称】
     */
    @DeleteMapping("/{ids}")
    @PreAuthorize("@ss.hasPermi('md:odSalesOrderDetailItem:remove')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
    public AjaxResult remove(@PathVariable List<Long> ids) {
        return odSalesOrderDetailItemService.deleteByIds(ids) ? AjaxResult.success() : AjaxResult.error();
    }
}
