package com.ximai.mes.md.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 工作中心对象 md_workstation
 *
 * @date 2024-03-16
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MdWorkstationVo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 工作中心ID
     */
    @TableId(type = IdType.AUTO)
    private Long workstationId;

    /**
     * 工作中心编码
     */
    private String workstationCode;

    /**
     * 工作中心名称
     */
    private String workstationName;

    /**
     * 工作中心类别
     */
    private String workstationType;

    /**
     * 工厂编号
     */
    private String factoryCode;

    /**
     * 工作中心用途
     */
    private String usageCode;

    /**
     * 车间ID
     */
    private Long workshopId;

    private String workshopName;

    /**
     * 车间编码
     */
    private String workshopCode;

    /**
     * 工序ID
     */
    private Long processId;

    private String processName;

    private String processCode;

    /**
     * 工作中心负责人
     */
    private String responsiblePerson;

    private String nickName;

    /**
     * 标准工时
     */
    private Long stdWorkingTime;

    /**
     * 标准值码
     */
    private String standardValueCode;

    /**
     * 加工方式
     */
    private String processingMethod;

    /**
     * 成本中心
     */
    private String costCenterCode;

    /**
     * 是否倒冲
     */
    private String isBackflush;

    /**
     * 看机人数
     */
    private BigDecimal watchingAircraftNum;

    /**
     * 是否启用
     */
    private String enableFlag;

    /**
     * 更新标志
     */
    private char updateLog;

    /**
     * 创建者
     */
    private String createBy;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 更新者
     */
    private String updateBy;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /**
     * 备注
     */
    private String remark;
    /**
     * 转间配送时间
     */
    private BigDecimal transferTime;
}
