package com.ximai.mes.md.vo;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.constant.TmToolMachineTypeEnum;
import com.ximai.mes.md.domain.MdBaseInfo;
import com.ximai.mes.md.domain.MdProductLook;
import com.ximai.mes.md.domain.MdProductPublishedConf;
import com.ximai.mes.md.domain.MdSaleUnit;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class MdItemVo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    private Long itemId;
    private Long toolId;
    private String toolCode;
    private String toolName;
    private Long workstationId;
    private String workstationName;
    private String typeName;


    private Integer type;

    private String dta;

    @Excel(name = "物料/产品编码", type = Excel.Type.EXPORT)
    @ApiModelProperty("物料/产品编码")
    private String itemCode;

    @Excel(name = "SAP产品编码", type = Excel.Type.EXPORT)
    private String sapItemCode;

    @Excel(name = "物料/产品名称", type = Excel.Type.ALL)
    private String itemName;

    private String productEnglishName;

    @Excel(name = "规格型号", type = Excel.Type.ALL)
    private String specification;

    @Excel(name = "计量单位名称", type = Excel.Type.ALL)
    private String unitOfMeasure;

    @Excel(name = "物料/产品", type = Excel.Type.ALL)
    private String itemOrProduct;


    private Long itemTypeId;

    private String itemTypeCode;

    @Excel(name = "物料/产品分类", type = Excel.Type.ALL)
    private String itemTypeName;

    @Excel(name = "是否启用", type = Excel.Type.EXPORT, dictType = "sys_yes_no")
    private String enableFlag;
    @Excel(name = "是否安全库存", type = Excel.Type.ALL, dictType = "sys_yes_no")
    private String safeStockFlag;

    @Excel(name = "英文名称", type = Excel.Type.ALL)
    private String itemEnglishName;

    @Excel(name = "备注", type = Excel.Type.ALL)
    private String remark;

    @Excel(name = "产品代号", type = Excel.Type.ALL)
    private String itemNo;

    @Excel(name = "最小库存", type = Excel.Type.ALL)
    private Double minStock;

    @Excel(name = "最大库存", type = Excel.Type.ALL)
    private Double maxStock;
    private String attr1;
    private String attr2;
    private String attr3;
    private String attr4;

    private MdBaseInfo baseInfo;

    private MdProductLook look;

    private MdProductPublishedConf publishedConf;

    private MdSaleUnit saleUnit;

    //@Excel(name = "是否正式产品", type = Excel.Type.EXPORT, dictType = "temporary_or_formal")
    private String isFormal;

    /**
     * 品牌id
     */
    private Long brandId;
    /**
     * 品牌编码
     */
    private String brandCode;
    /**
     * 品牌名称
     */
    private String brandName;

    private String message;

    /**
     * 长;单位cm
     */
    @Excel(name = "长;单位cm")
    private BigDecimal length;

    /**
     * 宽;单位cm
     */
    @Excel(name = "宽;单位cm")
    private BigDecimal width;

    /**
     * 高;单位cm
     */
    @Excel(name = "高;单位cm")
    private BigDecimal height;

    /**
     * 厚度;单位mm
     */
    @Excel(name = "厚度;单位mm")
    private BigDecimal thick;

    /**
     * 成品克重;单位g
     */
    @Excel(name = "成品克重;单位g")
    private BigDecimal weight;

    /**
     * 角型
     */
    @Excel(name = "角型")
    private String angleType;

    /**
     * 是否异型
     **/
    private String isAllotype;

    /**
     * 是否直角
     **/
    private String isRightAngle;

    /**
     * 圆角
     **/
    private String fillet;

    /**
     * 角度(单位mm)
     */
    @Excel(name = "角度(单位mm)")
    private BigDecimal angle;

    /**
     * 孔径(单位mm)
     */
    @Excel(name = "孔径(单位mm)")
    private BigDecimal aperture;

    /**
     * 单层厚(单位丝)
     */
    @Excel(name = "单层厚(单位丝)")
    private BigDecimal singleLayerThick;

    /**
     * 单重(单位KG)
     */
    @Excel(name = "单重(单位KG)")
    private BigDecimal singleWeight;

    /**
     * 层数
     */
    @Excel(name = "层数")
    private BigDecimal layerNum;

    /**
     * 是否防霉(is_open)
     */
    @Excel(name = "是否防霉(is_open)")
    private String isMould;

    /**
     * 是否写码(is_open)
     */
    @Excel(name = "是否写码(is_open)")
    private String isCoding;

    /**
     * 体系认证(product_sys_certification)
     */
    @Excel(name = "体系认证(product_sys_certification)")
    private String certification;

    /**
     * 样品形状：RIGHT-直角；ALLOTYPE-异型；FILLET-圆角；
     */
    @Excel(name = "样品形状：RIGHT-直角；ALLOTYPE-异型；FILLET-圆角；")
    private String shape;

    /**
     * 样品形状大小（mm）
     */
    @Excel(name = "样品形状大小", readConverterExp = "m=m")
    private BigDecimal shapeSize;

    /**
     * 尺码组id
     */
    private Long sizeGroupId;
    private String sizeGroupName;

    /**
     * 印张长度(单位cm)
     */
    private BigDecimal sheetLength;

    /**
     * 印张宽度(单位cm)
     */
    private BigDecimal sheetWidth;

    /**
     * 派工倍数
     */
    private BigDecimal dispatchMultiple;

    /**
     * 行数
     */
    private Integer rowNum;


    /**
     * 更新标志
     */
    private char updateLog;


    private Integer AllQuantity;
    private Integer nextMaintenPeriod;
    private String taskId;
    private String taskCode;
    private String taskName;
    private String workunitId;
    private String workunitCode;
    private String workunitName;
    private Long toolMachinesId;

    public String getTypeName() {
        return TmToolMachineTypeEnum.get(this.getType());
    }

}
