package com.ximai.mes.md.service.impl;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.constant.UserConstants;
import com.ximai.common.exception.ServiceException;
import com.ximai.common.utils.MessageUtils;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.common.utils.bean.BeanValidators;
import com.ximai.common.utils.excel.ExcelReader;
import com.ximai.mes.md.dto.MdVendorExcelImport;
import com.ximai.mes.remote.ErpService;
import com.ximai.mes.remote.dto.MdVendorErpDto;
import com.ximai.mes.remote.dto.MdVendorErpQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdVendorMapper;
import com.ximai.mes.md.domain.MdVendor;
import com.ximai.mes.md.service.IMdVendorService;

import javax.validation.Validator;

/**
 * 供应商Service业务层处理
 *
 * @date 2022-05-06
 */
@Service
public class MdVendorServiceImpl implements IMdVendorService
{
    @Autowired
    private MdVendorMapper mdVendorMapper;

    @Autowired
    protected Validator validator;
    @Autowired
    private ErpService erpService;

    /**
     * 查询供应商
     *
     * @param vendorId 供应商主键
     * @return 供应商
     */
    @Override
    public MdVendor selectMdVendorByVendorId(Long vendorId)
    {
        return mdVendorMapper.selectMdVendorByVendorId(vendorId);
    }

    /**
     * 查询供应商列表
     *
     * @param mdVendor 供应商
     * @return 供应商
     */
    @Override
    public List<MdVendor> selectMdVendorList(MdVendor mdVendor)
    {
        return mdVendorMapper.selectMdVendorList(mdVendor);
    }

    @Override
    public String checkVendorCodeUnique(MdVendor mdVendor) {
        MdVendor vendor = mdVendorMapper.checkVendorCodeUnique(mdVendor);
        Long vendorId = mdVendor.getVendorId()==null?-1L:mdVendor.getVendorId();
        if(StringUtils.isNotNull(vendor) && vendor.getVendorId().longValue() !=vendorId.longValue()){
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    @Override
    public String checkVendorNameUnique(MdVendor mdVendor) {
        MdVendor vendor = mdVendorMapper.checkVendorNameUnique(mdVendor);
        Long vendorId = mdVendor.getVendorId()==null?-1L:mdVendor.getVendorId();
        if(StringUtils.isNotNull(vendor) && vendor.getVendorId().longValue() !=vendorId.longValue()){
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    @Override
    public String checkVendorNickUnique(MdVendor mdVendor) {
        MdVendor vendor = mdVendorMapper.checkVendorNickUnique(mdVendor);
        Long vendorId = mdVendor.getVendorId()==null?-1L:mdVendor.getVendorId();
        if(StringUtils.isNotNull(vendor) && vendor.getVendorId().longValue() !=vendorId.longValue()){
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    private void importVendorImpl(MdVendorExcelImport importData, Boolean isUpdateSupport){
        MdVendor mdVendorQuery = new MdVendor();
        mdVendorQuery.setVendorCode(importData.getVendorCode());
        if(isUpdateSupport){
            List<MdVendor> list = this.selectMdVendorList(mdVendorQuery);
            if(list.size()==1){
                BeanUtil.copyProperties(importData, list.get(0));
                this.updateMdVendor(list.get(0));
            }else{
                MdVendor mdVendor = BeanUtil.toBeanIgnoreError(importData, MdVendor.class);
                this.insertMdVendor(mdVendor);
            }
        }else{
            MdVendor mdVendor = BeanUtil.toBeanIgnoreError(importData, MdVendor.class);
            this.insertMdVendor(mdVendor);
        }
    }

    @Override
    public void importVendor(InputStream inputStream, Boolean isUpdateSupport) {
        ExcelReader.read(inputStream, MdVendorExcelImport.class, this::importVendorImpl, isUpdateSupport);
    }

    /**
     * 新增供应商
     *
     * @param mdVendor 供应商
     * @return 结果
     */
    @Override
    public int insertMdVendor(MdVendor mdVendor)
    {
        mdVendor.setCreateTime(DateUtils.getNowDate());
        return mdVendorMapper.insertMdVendor(mdVendor);
    }

    /**
     * 修改供应商
     *
     * @param mdVendor 供应商
     * @return 结果
     */
    @Override
    public int updateMdVendor(MdVendor mdVendor)
    {
        mdVendor.setUpdateTime(DateUtils.getNowDate());
        return mdVendorMapper.updateMdVendor(mdVendor);
    }

    /**
     * 批量删除供应商
     *
     * @param vendorIds 需要删除的供应商主键
     * @return 结果
     */
    @Override
    public int deleteMdVendorByVendorIds(Long[] vendorIds)
    {
        return mdVendorMapper.deleteMdVendorByVendorIds(vendorIds);
    }

    /**
     * 删除供应商信息
     *
     * @param vendorId 供应商主键
     * @return 结果
     */
    @Override
    public int deleteMdVendorByVendorId(Long vendorId)
    {
        return mdVendorMapper.deleteMdVendorByVendorId(vendorId);
    }

    @Override
    public void syncErpData() {
        MdVendorErpQuery vendorErpQuery = new MdVendorErpQuery();
        List<MdVendorErpDto> list = erpService.getVendorList(vendorErpQuery).getData();
        list.forEach(s->{
            MdVendor mdVendorQuery = new MdVendor();
            mdVendorQuery.setVendorCode(s.getVendorCode());
            List<MdVendor> dbList = mdVendorMapper.selectMdVendorList(mdVendorQuery);
            if(dbList.size()==0){
                if("1".equals(s.getVerifyStatus())){
                    MdVendor insertTemp = BeanUtil.toBean(s, MdVendor.class);
                    this.insertMdVendor(insertTemp);
                }
            }else{
                BeanUtil.copyProperties(s, dbList.get(0));
                if(!"1".equals(s.getVerifyStatus())){
                    dbList.get(0).setEnableFlag("N");
                }
                this.updateMdVendor(dbList.get(0));
            }
        });
    }

}
