package com.ximai.mes.md.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.md.domain.MdWorkunit;
import com.ximai.mes.md.vo.MdWorkunitVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 工作单元Service接口
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
public interface IMdWorkunitService {

    public static Long OUTSOURCE_WORKUNIT_ID = 1l;
    public static String OUTSOURCE_WORKUNIT_CODE = "XMWWDY";
    /**
     * 查询工作单元
     *
     * @param workunitId 工作单元主键
     * @return 工作单元
     */
    MdWorkunitVo selectMdWorkunitByWorkunitId(Long workunitId);

    /**
     * 查询工作单元列表
     *
     * @param mdWorkunit 工作单元
     * @return 工作单元集合
     */
    List<MdWorkunitVo> selectMdWorkunitList(MdWorkunit mdWorkunit);


    List<MdWorkunitVo> selectMdWorkstationListByUser(String userName);

    List<MdWorkunitVo> selectMdWorkunitListByUser(QueryWrapper<MdWorkunit> query);

    /**
     * 新增工作单元
     *
     * @param mdWorkunit 工作单元
     * @return 结果
     */
    int insertMdWorkunit(MdWorkunit mdWorkunit);

    int insertMdWorkunit2(MdWorkunit mdWorkunit);

    /**
     * 修改工作单元
     *
     * @param mdWorkunit 工作单元
     * @return 结果
     */
    int updateMdWorkunit(MdWorkunit mdWorkunit);

    int updateMdWorkunits(MdWorkunit mdWorkunit);

    /**
     * 批量删除工作单元
     *
     * @param workunitIds 需要删除的工作单元主键集合
     * @return 结果
     */
    int deleteMdWorkunitByWorkunitIds(Long[] workunitIds);

    /**
     * 删除工作单元信息
     *
     * @param workunitId 工作单元主键
     * @return 结果
     */
    int deleteMdWorkunitByWorkunitId(Long workunitId);


    /**
     * ep传mes工作单元新增
     *
     * @param mdWorkstationVo 工作单元主键
     * @return 结果
     */
    int workunitCreate(MdWorkunitVo mdWorkstationVo);

    /**
     * 关联工作中心查询作业单元列表
     *
     * @param query
     * @return
     */
    List<MdWorkunitVo> selectMdWorkunitJoinWorkstation(@Param("ew") QueryWrapper<MdWorkunitVo> query);


    List<MdWorkunit> selectListByQw(QueryWrapper<MdWorkunit> query);
}
