package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdProductSpec;

/**
 * 产品特性名称Service接口
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
public interface IMdProductSpecService
{
    /**
     * 查询产品特性名称
     *
     * @param itemSpecId 产品特性名称主键
     * @return 产品特性名称
     */
    public MdProductSpec selectMdItemSpecByItemSpecId(Long itemSpecId);

    /**
     * 查询产品特性名称列表
     *
     * @param mdProductSpec 产品特性名称
     * @return 产品特性名称集合
     */
    public List<MdProductSpec> selectMdItemSpecList(MdProductSpec mdProductSpec);

    /**
     * 新增产品特性名称
     *
     * @param mdProductSpec 产品特性名称
     * @return 结果
     */
    public int insertMdItemSpec(MdProductSpec mdProductSpec);

    /**
     * 修改产品特性名称
     *
     * @param mdProductSpec 产品特性名称
     * @return 结果
     */
    public int updateMdItemSpec(MdProductSpec mdProductSpec);

    /**
     * 批量删除产品特性名称
     *
     * @param itemSpecIds 需要删除的产品特性名称主键集合
     * @return 结果
     */
    public int deleteMdItemSpecByItemSpecIds(Long[] itemSpecIds);

    /**
     * 删除产品特性名称信息
     *
     * @param itemSpecId 产品特性名称主键
     * @return 结果
     */
    public int deleteMdItemSpecByItemSpecId(Long itemSpecId);
}
