package com.ximai.mes.md.mapper;

import java.util.List;
import com.ximai.mes.md.domain.MdSaleOrderOffice;

/**
 * 销售订单办事处Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
public interface MdSaleOrderOfficeMapper
{
    /**
     * 查询销售订单办事处
     *
     * @param id 销售订单办事处主键
     * @return 销售订单办事处
     */
    public MdSaleOrderOffice selectMdSaleOrderOfficeById(Long id);

    /**
     * 查询销售订单办事处列表
     *
     * @param mdSaleOrderOffice 销售订单办事处
     * @return 销售订单办事处集合
     */
    public List<MdSaleOrderOffice> selectMdSaleOrderOfficeList(MdSaleOrderOffice mdSaleOrderOffice);

    /**
     * 新增销售订单办事处
     *
     * @param mdSaleOrderOffice 销售订单办事处
     * @return 结果
     */
    public int insertMdSaleOrderOffice(MdSaleOrderOffice mdSaleOrderOffice);

    /**
     * 修改销售订单办事处
     *
     * @param mdSaleOrderOffice 销售订单办事处
     * @return 结果
     */
    public int updateMdSaleOrderOffice(MdSaleOrderOffice mdSaleOrderOffice);

    /**
     * 删除销售订单办事处
     *
     * @param id 销售订单办事处主键
     * @return 结果
     */
    public int deleteMdSaleOrderOfficeById(Long id);

    /**
     * 批量删除销售订单办事处
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdSaleOrderOfficeByIds(Long[] ids);
}
