package com.ximai.mes.md.mapper;

import java.util.List;
import com.ximai.mes.md.domain.MdFactory;
import org.apache.ibatis.annotations.Param;

/**
 * 工厂Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
public interface MdFactoryMapper
{
    /**
     * 查询工厂
     *
     * @param factoryId 工厂主键
     * @return 工厂
     */
    public MdFactory selectMdFactoryByFactoryId(Long factoryId);

    /**
     * 查询工厂列表
     *
     * @param mdFactory 工厂
     * @return 工厂集合
     */
    public List<MdFactory> selectMdFactoryList(MdFactory mdFactory);

    /**
     * 新增工厂
     *
     * @param mdFactory 工厂
     * @return 结果
     */
    public int insertMdFactory(MdFactory mdFactory);

    /**
     * 修改工厂
     *
     * @param mdFactory 工厂
     * @return 结果
     */
    public int updateMdFactory(MdFactory mdFactory);

    /**
     * 删除工厂
     *
     * @param factoryId 工厂主键
     * @return 结果
     */
    public int deleteMdFactoryByFactoryId(Long factoryId);

    /**
     * 批量删除工厂
     *
     * @param factoryIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdFactoryByFactoryIds(Long[] factoryIds);

    MdFactory selectMdFactoryByFactoryCode(@Param("factoryCode") String factoryCode);
}
