package com.ximai.mes.md.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 工作站对象 md_workstation
 *
 * @date 2022-05-10
 */
@Data
@ApiModel("工作站")
@AllArgsConstructor
@NoArgsConstructor
public class MdWorkstationExcelExport extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 工作中心ID
     */
    @TableId(type = IdType.AUTO)
    private Long workstationId;

    /**
     * 工作中心编码
     */
    @ExcelProperty("工作中心编码")
    @ApiModelProperty("工作中心编码")
    private String workstationCode;

    /**
     * 工作中心名称
     */
    @ExcelProperty("工作中心名称")
    @ApiModelProperty("工作中心名称")
    private String workstationName;

    /**
     * 工作中心类别
     */
    @ExcelProperty("工作中心类别")
    @ApiModelProperty("工作中心类别")
    private String workstationType;

    /**
     * 工厂编号
     */
    @ExcelProperty("工厂编号")
    private String factoryCode;

    /**
     * 工作中心用途
     */
    @ExcelProperty("工作中心用途")
    private String usageCode;

    /**
     * 车间ID
     */
    @ExcelProperty("车间ID")
    @ApiModelProperty("车间ID")
    private Long workshopId;

    private String workshopName;

    private String workshopCode;
    /**
     * 工序ID
     */
    @ExcelProperty("工序ID")
    private Long processId;

    private String processName;

    private String processCode;

    /**
     * 工作中心负责人
     */
    @ExcelProperty("工作中心负责人")
    private String responsiblePerson;

    private String nickName;

    /**
     * 标准工时
     */
    @ExcelProperty("标准工时")
    @ApiModelProperty("标准工时")
    private Long stdWorkingTime;

    /**
     * 标准值码
     */
    @ExcelProperty("标准值码")
    @ApiModelProperty("标准值码")
    private String standardValueCode;

    /**
     * 加工方式
     */
    @ExcelProperty("加工方式")
    @ApiModelProperty("加工方式")
    private String processingMethod;

    /**
     * 成本中心
     */
    @ExcelProperty("成本中心")
    @ApiModelProperty("成本中心")
    private String costCenterCode;

    /**
     * 是否倒冲
     */
    @ExcelProperty("是否倒冲")
    @ApiModelProperty("是否倒冲")
    private String isBackflush;

    /**
     * 看机人数
     */
    @ExcelProperty("看机人数")
    @ApiModelProperty("看机人数")
    private BigDecimal watchingAircraftNum;

    /**
     * 是否启用
     */
    @ExcelProperty("是否启用")
    private String enableFlag;

    /**
     * 转间配送时间
     */
    @ExcelProperty("转间配送时间")
    private BigDecimal transferTime;

}
