package com.ximai.mes.md.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.md.domain.MdBaseInfo;
import com.ximai.mes.md.domain.MdProductLook;
import com.ximai.mes.md.domain.MdProductPublishedConf;
import com.ximai.mes.md.domain.MdSaleUnit;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.List;


@Data
@ApiModel("物料基础")
public class MdItemExcelImport {

    private static final long serialVersionUID = 1L;

    @ExcelProperty("物料/产品编码")
    private String itemCode;

    private String dta;

    @ExcelProperty("SAP产品编码")
    private String sapItemCode;


    @ExcelProperty("物料/产品名称")
    private String itemName;

    @ExcelProperty("规格型号")
    private String specification;

    @ExcelProperty("计量单位名称")
    private String unitOfMeasure;

    @ExcelProperty("物料/产品")
    private String itemOrProduct;

    @ExcelProperty("物料/产品分类")
    private String itemTypeName;

    @ExcelProperty("是否启用")
    private String enableFlag;
    @ExcelProperty("是否安全库存")
    private String safeStockFlag;

    @ExcelProperty("英文名称")
    private String itemEnglishName;

    @ExcelProperty("产品代号")
    private String itemNo;

    @ExcelProperty("最小库存")
    private Double minStock;

    @ExcelProperty("最大库存")
    private Double maxStock;


}
