package com.ximai.mes.md.domain;

import java.math.BigDecimal;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 产品loss配置对象 md_product_loss
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
public class MdProductLoss extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 产品lossID */
    private Long productLossId;

    /** 产品ID */
    @Excel(name = "产品ID")
    private Long itemId;

    /** 客户ID */
    @Excel(name = "客户ID")
    private Long customerId;

    /** 分段数量*/
    @Excel(name = "分段数量")
    private BigDecimal segmentCount;

    /** 最大loss数*/
    @Excel(name = "最大loss数")
    private BigDecimal maxLossCount;

    /** loss比率(单位%) */
    @Excel(name = "loss比率(单位%)")
    private BigDecimal lossRate;

    /** 冗余量 */
    @Excel(name = "冗余量")
    private BigDecimal lossRedundance;

    /** 备注信息 */
    @Excel(name = "备注信息")
    private String remark;

    public Long getProductLossId() {
        return productLossId;
    }

    public void setProductLossId(Long productLossId) {
        this.productLossId = productLossId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public BigDecimal getSegmentCount() {
        return segmentCount;
    }

    public void setSegmentCount(BigDecimal segmentCount) {
        this.segmentCount = segmentCount;
    }

    public BigDecimal getMaxLossCount() {
        return maxLossCount;
    }

    public void setMaxLossCount(BigDecimal maxLossCount) {
        this.maxLossCount = maxLossCount;
    }

    public BigDecimal getLossRate() {
        return lossRate;
    }

    public void setLossRate(BigDecimal lossRate) {
        this.lossRate = lossRate;
    }

    public BigDecimal getLossRedundance() {
        return lossRedundance;
    }

    public void setLossRedundance(BigDecimal lossRedundance) {
        this.lossRedundance = lossRedundance;
    }

    @Override
    public String getRemark() {
        return remark;
    }

    @Override
    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public String toString() {
        return "MdProductLoss{" +
                "productLossId=" + productLossId +
                ", itemId=" + itemId +
                ", customerId=" + customerId +
                ", segmentCount=" + segmentCount +
                ", maxLossCount=" + maxLossCount +
                ", lossRate=" + lossRate +
                ", lossRedundance=" + lossRedundance +
                ", remark='" + remark + '\'' +
                '}';
    }
}
