package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdVehicle;
import com.ximai.mes.md.service.IMdVehicleService;
import com.ximai.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 车辆列表Controller
 *
 * @author generator
 * @date 2024-01-25
 */
@RestController
@RequestMapping("/md/vehicle")
public class MdVehicleController extends BaseController
{
    @Autowired
    private IMdVehicleService mdVehicleService;

    /**
     * 查询车辆列表列表
     */
    @PreAuthorize("@ss.hasPermi('md:vehicle:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdVehicle mdVehicle)
    {
        startPage();
        List<MdVehicle> list = mdVehicleService.selectMdVehicleList(mdVehicle);
        return getDataTable(list);
    }


    /**
     * 获取车辆列表详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:vehicle:query')")
    @GetMapping(value = "/{vehicleId}")
    public AjaxResult getInfo(@PathVariable("vehicleId") Long vehicleId)
    {
        return AjaxResult.success(mdVehicleService.selectMdVehicleByVehicleId(vehicleId));
    }

    /**
     * 新增车辆列表
     */
    @PreAuthorize("@ss.hasPermi('md:vehicle:add')")
    @Log(title = "车辆列表", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdVehicle mdVehicle)
    {
        return toAjax(mdVehicleService.insertMdVehicle(mdVehicle));
    }

    /**
     * 修改车辆列表
     */
    @PreAuthorize("@ss.hasPermi('md:vehicle:edit')")
    @Log(title = "车辆列表", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdVehicle mdVehicle)
    {
        return toAjax(mdVehicleService.updateMdVehicle(mdVehicle));
    }

    /**
     * 删除车辆列表
     */
    @PreAuthorize("@ss.hasPermi('md:vehicle:remove')")
    @Log(title = "车辆列表", businessType = BusinessType.DELETE)
	@DeleteMapping("/{vehicleIds}")
    public AjaxResult remove(@PathVariable Long[] vehicleIds)
    {
        return toAjax(mdVehicleService.deleteMdVehicleByVehicleIds(vehicleIds));
    }

    @Log(title = "车辆列表", businessType = BusinessType.IMPORT)
    @PreAuthorize("@ss.hasPermi('md:vehicle:import')")
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception
    {
        String operName = getUsername();
        mdVehicleService.importVehicle(file, updateSupport, operName);
        return AjaxResult.success();
    }
}
