package com.ximai.mes.constant;

/**
 * 任务单状态
 *
 * @ Author: chicheng.li
 * @ Date  : 2024/2/4
 */
public enum TmMachineCheckErrorEnum {


    ERROR_01(1, "刀模版记录未被创建"),


    ERROR_04(4, "刀模版具并未全部上机"),
    
    ERROR_06(6, "工序任务无刀模版具需要创建");

    private final Integer status;
    private final String msg;

    TmMachineCheckErrorEnum(Integer status, String msg) {
        this.status = status;
        this.msg = msg;
    }

    public Integer getStatus() {
        return status;
    }

    public String getMsg() {
        return msg;
    }

    public static String get(Integer type) {
        for (TmMachineCheckErrorEnum temp : TmMachineCheckErrorEnum.values()) {
            if (temp.getStatus().equals(type)) {
                return temp.getMsg();
            }
        }
//        return  null
        return TmMachineCheckErrorEnum.ERROR_04.getMsg();
//        throw new RuntimeException("异常上机类型");
    }
}
