package com.ximai.mes.constant;

/**
 * 任务单状态
 *
 * @ Author: chicheng.li
 * @ Date  : 2024/2/4
 */
public enum TaskStatusEnum {

    /**
     * 未下达
     */
    UN_ASSIGN("UN_ASSIGN", "未下达"),

    /**
     * 未开工
     */
    PREPARE("PREPARE", "未开工"),
    /**
     * 已开工
     */
    BEGINNING("BEGINNING", "已开工"),
    /**
     * 暂停
     */
    PAUSE("PAUSE", "暂停"),
    /**
     * 取消
     */
    CANCEL("CANCEL", "取消"),
    /**
     * 异常停工
     */
    ERROR_STOP("ERROR_STOP", "异常停工"),
    CLOSE("CLOSE", "关闭"),
    /**
     * 完工
     */
    FINISHED("FINISHED", "完工");

    /**
     * Lock type
     */
    private final String status;

    private final String statusCn;

    TaskStatusEnum(String status, String statusCn) {
        this.status = status;
        this.statusCn = statusCn;
    }

    public String getStatus() {
        return status;
    }

    public String getStatusCn() {
        return statusCn;
    }


    public static TaskStatusEnum get(String status) {
        for (TaskStatusEnum temp : TaskStatusEnum.values()) {
            if (temp.getStatus().equals(status)) {
                return temp;
            }
        }
        return null;
    }


    public static String getStatusNomalCn(String status) {
        for (TaskStatusEnum temp : TaskStatusEnum.values()) {
            if (temp.getStatus().equals(status)) {
                return temp.getStatusCn();
            }
        }
        return "未开始";
    }

    public static String getStatusCn(String status) {
        for (TaskStatusEnum temp : TaskStatusEnum.values()) {
            if (temp.getStatus().equals(status)) {
                return temp.getStatusCn();
            }
        }
        return null;
    }

}
