package com.ximai.mes.cal.service;

import com.ximai.mes.cal.domain.CalPlan;
import org.springframework.scheduling.annotation.Async;

import java.util.List;

/**
 * 排班计划Service接口
 *
 * @date 2022-06-06
 */
public interface ICalPlanService {
    /**
     * 查询排班计划
     *
     * @param planId 排班计划主键
     * @return 排班计划
     */
    CalPlan selectCalPlanByPlanId(Long planId);

    /**
     * 查询排班计划列表
     *
     * @param calPlan 排班计划
     * @return 排班计划集合
     */
    List<CalPlan> selectCalPlanList(CalPlan calPlan);

    /**
     * 新增排班计划
     *
     * @param calPlan 排班计划
     * @return 结果
     */
    int insertCalPlan(CalPlan calPlan);

    /**
     * 修改排班计划
     *
     * @param calPlan 排班计划
     * @return 结果
     */
    int updateCalPlan(CalPlan calPlan);

    /**
     * 批量删除排班计划
     *
     * @param planIds 需要删除的排班计划主键集合
     * @return 结果
     */
    int deleteCalPlanByPlanIds(Long[] planIds);

    /**
     * 删除排班计划信息
     *
     * @param planId 排班计划主键
     * @return 结果
     */
    int deleteCalPlanByPlanId(Long planId);

    @Async
    void genRecords(CalPlan calPlan);

    void releasePlan(CalPlan calPlan);

    void updateRelationship(CalPlan calPlan);

    void insertCalWorkunits(CalPlan calPlan);
}
