package com.ximai.mes.cal.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.cal.domain.CalPlanWorkunit;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 计划工作单元Mapper接口
 *
 * @author generator
 * @date 2024-03-14
 */
public interface CalPlanWorkunitMapper extends BaseMapper<CalPlanWorkunit> {

    /**
     * 查询计划工作单元列表
     *
     * @param calPlanWorkunit 计划工作单元
     * @return 计划工作单元集合
     */
    List<CalPlanWorkunit> selectCalPlanWorkunitList(CalPlanWorkunit calPlanWorkunit);

    List<CalPlanWorkunit> selectCalPlanWorkunitListV2(CalPlanWorkunit calPlanWorkunit);

    /**
     * 新增计划工作单元
     *
     * @param calPlanWorkunit 计划工作单元
     * @return 结果
     */
    int insertCalPlanWorkunit(CalPlanWorkunit calPlanWorkunit);

    int insertBatchCalPlanWorkunits(@Param("calPlanWorkunits") List<CalPlanWorkunit> calPlanWorkunits);

    /**
     * 修改计划工作单元
     *
     * @param calPlanWorkunit 计划工作单元
     * @return 结果
     */
    int updateCalPlanWorkunit(CalPlanWorkunit calPlanWorkunit);

    /**
     * 删除计划工作单元
     *
     * @param planWorkunitId 计划工作单元主键
     * @return 结果
     */
    int deleteCalPlanWorkunitByid(Long planWorkunitId);

    /**
     * 批量删除计划工作单元
     *
     * @param planWorkunitIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteCalPlanWorkunitByids(Long[] planWorkunitIds);

    @Update("update cal_plan_workunit set  is_work = 2, update_by = #{obj.updateBy}, update_time = #{obj.updateTime} where   workunit_id = #{obj.workunitId} and shift_name = #{obj.shiftName} and the_day = #{obj.theDay}")
    int updateCalPlanWorkunitWorkStatus(@Param("obj") CalPlanWorkunit calPlanWorkunit);


    /**
     * 查询计划工作单元列表
     *
     * @param query 计划工作单元
     * @return 计划工作单元集合
     */
    @Select(value = "select t1.* from cal_plan_workunit t1\n" +
            "${ew.customSqlSegment}")
    List<CalPlanWorkunit> selectListByQw(@Param("ew") QueryWrapper<CalPlanWorkunit> query);

    /**
     * 查询计划工作单元列表（排产专用）
     *
     * @param query 计划工作单元
     * @return 计划工作单元集合
     */
    @Select(value = "select t1.id,t1.workunit_id,t1.start_date,t1.end_date,t1.shift_type from cal_plan_workunit t1\n" +
            "${ew.customSqlSegment}")
    List<CalPlanWorkunit> selectListWithSchedule(@Param("ew") QueryWrapper<CalPlanWorkunit> query);

}
