package com.ximai.mes.cal.domain.vo;

import com.ximai.common.core.domain.BaseEntity;
import lombok.Data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 计划班次对象 cal_shift
 *
 * @date 2022-06-06
 */
@Data
public class CalShiftVo extends BaseEntity implements Comparable<CalShiftVo> {
    private static final long serialVersionUID = 1L;

    @Override
    public int compareTo(CalShiftVo o) {
        if (this.orderNum > o.getOrderNum()) {
            return 1;
        } else if (this.orderNum < o.getOrderNum()) {
            return -1;
        } else {
            return 0;
        }
    }

    private int restFlag = 0;

    /**
     * 班次ID
     */
    private Long shiftId;


    /**
     * 计划ID
     */
    private Long planId;
    private String planCode;

    /**
     * 序号
     */
    private Integer orderNum;

    /**
     * 班次名称
     */
    private String shiftName;
    private String shiftType;


    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

    private Integer operType;

    /**
     * 开始时间
     */
    private Date startDate;

    /**
     * 结束时间
     */
    private Date endDate;

    private String breakStartTime;

    private String breakEndTime;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;

    //    @TableField(exist = false)
    private Long workunitId;

    //    @TableField(exist = false)
    private String workunitCode;

    //    @TableField(exist = false)
    private String workunitName;

    //    @TableField(exist = false)
    private String theDay;

    private Integer isWork;


    private String workstationName;
    private String workshopName;
    private List<CalShiftVo> breakTimeList = new ArrayList<>();
}
