package com.ximai.common.core.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.ximai.common.annotation.Excel;
import com.ximai.common.annotation.Excel.ColumnType;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * 字典类型表 sys_dict_type
 *
 */
@Data
@ApiModel("字典类型导出")
public class SysDictTypeExcelExport 
{
    private static final long serialVersionUID = 1L;

    /** 字典主键 */
   @ExcelProperty("字典主键")
    private Long dictId;

    /** 字典名称 */
   @ExcelProperty("字典名称")
    private String dictName;

    /** 字典类型 */
   @ExcelProperty("字典类型")
    private String dictType;

    /** 状态（0正常 1停用） */
   @ExcelProperty("状态")
    private String status;

}
