package com.ximai.web.controller.system;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.common.utils.SecurityUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.system.domain.SysUserAssocintionPrint;
import com.ximai.system.service.ISysUserAssocintionPrintService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 人员关联打印机表Controller
 *
 * @author generator
 * @date 2024-03-16
 */
@RestController
@RequestMapping("/system/print")
public class SysUserAssocintionPrintController extends BaseController
{
    @Autowired
    private ISysUserAssocintionPrintService sysUserAssocintionPrintService;

    /**
     * 查询人员关联打印机表列表
     */
    @PreAuthorize("@ss.hasPermi('system:print:list')")
    @GetMapping("/list")
    public TableDataInfo list(SysUserAssocintionPrint sysUserAssocintionPrint)
    {
        startPage();
        List<SysUserAssocintionPrint> list = sysUserAssocintionPrintService.selectSysUserAssocintionPrintList(sysUserAssocintionPrint);
        return getDataTable(list);
    }

    /**
     * 获取人员关联打印机表详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:print:query')")
    @GetMapping(value = "/{userPrintId}")
    public AjaxResult getInfo(@PathVariable("userPrintId") Long userPrintId)
    {
        return AjaxResult.success(sysUserAssocintionPrintService.selectSysUserAssocintionPrintByUserPrintId(userPrintId));
    }


    /**
     * 获取人员ID关联打印机表详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:print:query')")
    @GetMapping(value = "/printer")
    public AjaxResult getPrinter()
    {
        return AjaxResult.success(sysUserAssocintionPrintService.selectSysUserAssocintionPrintByUserPrintIdUserId(SecurityUtils.getUserId()));
    }

    /**
     * 新增人员关联打印机表
     */
    @PreAuthorize("@ss.hasPermi('system:print:add')")
    @Log(title = "人员关联打印机表", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysUserAssocintionPrint sysUserAssocintionPrint)
    {
        return toAjax(sysUserAssocintionPrintService.insertSysUserAssocintionPrint(sysUserAssocintionPrint));
    }

    /**
     * 修改人员关联打印机表
     */
    @PreAuthorize("@ss.hasPermi('system:print:edit')")
    @Log(title = "人员关联打印机表", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysUserAssocintionPrint sysUserAssocintionPrint)
    {
        return toAjax(sysUserAssocintionPrintService.updateSysUserAssocintionPrint(sysUserAssocintionPrint));
    }

    /**
     * 删除人员关联打印机表
     */
    @PreAuthorize("@ss.hasPermi('system:print:remove')")
    @Log(title = "人员关联打印机表", businessType = BusinessType.DELETE)
	@DeleteMapping("/{userPrintIds}")
    public AjaxResult remove(@PathVariable Long[] userPrintIds)
    {
        return toAjax(sysUserAssocintionPrintService.deleteSysUserAssocintionPrintByUserPrintIds(userPrintIds));
    }
}
